/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.vo.AppDeveloperVO;
import cn.com.duiba.developer.center.api.domain.vo.AppManageVO;
import cn.com.duiba.developer.center.biz.dao.app.AppDao;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactory;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.SecureTool;
import cn.com.duiba.developer.center.common.tools.SwicthTool;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppServiceImpl
implements AppService {
    private static final Logger log = LoggerFactory.getLogger(AppServiceImpl.class);
    @Resource
    private AppDao appDao;
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private AppGroupFactory factory;
    @Autowired
    private BizEventBus eventBus;
    private Cache<Long, String> appSecretCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
        this.factory.registFactoryBean(this);
    }

    @Subscribe
    public void AppUpdateLister(AppUpdateEvent event) {
        this.removeCacheById(event.getAppId());
    }

    @Override
    public List<AppSimpleDto> findByIds(List<Long> ids) {
        if (Objects.equals(null, ids) || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.appDao.findByIds(ids);
    }

    @Override
    public List<AppSimpleDto> findAll() {
        return this.appDao.findAll();
    }

    @Override
    public Class<?> getObjectType() {
        return AppSimpleDto.class;
    }

    @Override
    public AppSimpleDto getObject(Long appId) {
        AppSimpleDto a = (AppSimpleDto)this.memcachedClient.get(this.getAppIdKey(appId));
        if (Objects.equals(null, a)) {
            a = this.appDao.find(appId);
            a.setAppSecret(this.getAppSecret(appId));
            this.memcachedClient.set(this.getAppIdKey(appId), (Object)a, 300);
        }
        return a;
    }

    private String getAppIdKey(Long id) {
        return "dcm_key_appId_" + id;
    }

    private void removeCacheById(Long id) {
        this.memcachedClient.remove(this.getAppIdKey(id));
        this.memcachedClient.remove("chaos.key_appId_" + id);
    }

    @Override
    public void insert(AppDO app) {
        this.appDao.insert(app);
    }

    @Override
    public void updata(AppDO app) {
        this.appDao.update(app);
    }

    @Override
    public List<Long> findAllEnable() {
        return this.appDao.findAllEnable();
    }

    @Override
    @Transactional(value="credits")
    public AppSimpleDto findForUpdate(Long id) {
        return this.appDao.findForUpdate(id);
    }

    @Override
    public int updateSwitch(SwicthTool tool) {
        int ret = this.appDao.updateSwitch(tool.getId(), tool.getSwicthValue());
        this.removeCacheById(tool.getId());
        return ret;
    }

    @Override
    public List<AppSimpleDto> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds) {
        return this.appDao.findAllBySpecifyAndBlack(specifyAppIds, blackAppIds);
    }

    @Override
    public AppSimpleDto findByAppKey(String appKey) {
        return this.appDao.findByAppKey(appKey);
    }

    @Override
    public List<AppSimpleDto> findAllByDeveloper(Long developerId) {
        return this.appDao.findAllByDeveloper(developerId);
    }

    @Override
    public List<AppSimpleDto> findAppNameByNameLike(String appName) {
        return this.appDao.findAppNameByNameLike(appName);
    }

    @Override
    public Integer countItemAutoRecommandApp(Long itemId) {
        return this.appDao.countItemAutoRecommandApp(itemId);
    }

    @Override
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId) {
        return this.appDao.getAutoRecommandAppIdListByItemId(itemId);
    }

    @Override
    public List<AppSimpleDto> findAllByDeveloperIds(List<Long> developerIds) {
        if (developerIds == null) {
            throw new RuntimeException("\u93cc\u30e8\ue1d7App\u93c3\ufffd,\u6d7c\u72b2\u53c6developerIds\u6d93\u8679\u2516");
        }
        if (developerIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.appDao.findAllByDeveloperIds(developerIds);
    }

    @Override
    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap) {
        return this.appDao.findAppListByCondition(queryMap);
    }

    @Override
    public Integer findAppListCount(Map<String, Object> queryMap) {
        return this.appDao.findAppListCount(queryMap);
    }

    @Override
    public AppSimpleDto findFristAppByDeveloperId(Long developerId) {
        String key = "dcm_firstAppOfDevId_" + developerId;
        AppSimpleDto firstApp = (AppSimpleDto)this.memcachedClient.get(key);
        if (firstApp == null) {
            firstApp = this.appDao.findFristAppByDeveloperId(developerId);
            this.memcachedClient.set(key, (Object)firstApp, 1, TimeUnit.HOURS);
        }
        return firstApp;
    }

    @Override
    public List<AppSimpleDto> findByAppIds(List<Long> appIds) {
        if (appIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.appDao.findByAppIds(appIds);
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList) {
        return this.appDao.selectAppDeveloper(appIdList);
    }

    @Override
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize) {
        return this.appDao.selectAllAppDeveloper(start, pageSize);
    }

    @Override
    public Map<String, Object> selectOneAppDeveloper(Long appId) {
        return this.appDao.selectOneAppDeveloper(appId);
    }

    @Override
    public List<Long> selectAppIdByName(String appName) {
        return this.appDao.selectAppIdByName(appName);
    }

    @Override
    public List<Long> selectAppIdByEmail(String email) {
        return this.appDao.selectAppIdByEmail(email);
    }

    @Override
    public List<Long> selectAppIdByEmailAndName(String email, String appName) {
        return this.appDao.selectAppIdByEmailAndName(email, appName);
    }

    @Override
    public Integer countApp() {
        return this.appDao.countApp();
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList) {
        return this.appDao.selectAppDeveloperByAppId(appIdList);
    }

    @Override
    public Integer findAppCountByDevId(Long developerId) {
        return this.appDao.findAppCountByDevId(developerId);
    }

    @Override
    public String getAppSecret(final Long id) {
        try {
            return (String)this.appSecretCache.get((Object)id, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String secretCode = AppServiceImpl.this.appDao.findAppSecretCode(id);
                    return SecureTool.decryptAppSecretCode((String)secretCode);
                }
            });
        }
        catch (ExecutionException e) {
            log.error("\u9354\u72ba\u6d47AppSecret\u6fb6\u8fab\u89e6");
            return "";
        }
    }
}

