/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppUrlDto;
import cn.com.duiba.developer.center.biz.dao.app.AppUrlDao;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactory;
import cn.com.duiba.developer.center.biz.service.credits.AppUrlService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppUrlServiceImpl
implements AppUrlService {
    @Resource
    private CacheClient memcachedClient;
    @Resource
    private AppUrlDao appUrlDao;
    @Autowired
    private AppGroupFactory factory;
    @Autowired
    private BizEventBus eventBus;

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
        this.factory.registFactoryBean(this);
    }

    @Subscribe
    public void AppUpdateLister(AppUpdateEvent event) {
        this.removeCacheById(event.getAppId());
    }

    @Override
    public Class<?> getObjectType() {
        return AppUrlDto.class;
    }

    @Override
    public AppUrlDto getObject(Long appId) {
        AppUrlDto a = (AppUrlDto)this.memcachedClient.get(this.getAppIdKey(appId));
        if (Objects.equals(null, a)) {
            a = this.appUrlDao.find(appId);
            this.memcachedClient.set(this.getAppIdKey(appId), (Object)a, 300);
        }
        return a;
    }

    private void removeCacheById(Long id) {
        this.memcachedClient.remove(this.getAppIdKey(id));
    }

    private String getAppIdKey(Long id) {
        StringBuilder sb = new StringBuilder();
        sb.append("dcm_keyAppUrlByAppId_").append(id);
        return sb.toString();
    }
}

