/**
 * Project Name:developer-center-biz
 * File Name:TagBoImpl.java
 * Package Name:cn.com.duiba.developer.center.biz.bo.impl
 * Date:2016年8月16日下午2:49:13
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.biz.bo.impl;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.developer.center.biz.bo.TagBo;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.entity.AppTagsMaskingEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.TagsService;
import cn.com.duiba.developer.center.common.constants.DsConstants;


/**
 * ClassName:TagBoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年8月16日 下午2:49:13 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class TagBoImpl implements TagBo {

    @Autowired
    private AppService appService;
    
    @Autowired
    private TagsService tagsService;
    
    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS)
    public void setShieldTags(Long appId, boolean autoRecommend, List<Long> tagids) {
        AppSimpleDto app = new AppSimpleDto();
        app.setId(appId);
        app.setAutoRecommend(autoRecommend);
        appService.update(app);
        tagsService.deleteTagMaskingByAppId(app.getId());
        if(CollectionUtils.isNotEmpty(tagids)){
            AppTagsMaskingEntity appTags = new AppTagsMaskingEntity();
            for(Long id : tagids){
                appTags.setAppId(app.getId());
                appTags.setTagsId(id);
                tagsService.insertTagMasking(appTags);
            }
        }
    }

}

