/**
 * Project Name:developer-center-biz
 * File Name:AppTagsMaskingDtoImpl.java
 * Package Name:cn.com.duiba.developer.center.biz.dao.app.impl
 * Date:2016年8月16日上午10:31:26
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.biz.dao.app.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.developer.center.biz.dao.app.AppTagsMaskingDao;
import cn.com.duiba.developer.center.biz.entity.AppTagsMaskingEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;


/**
 * ClassName:AppTagsMaskingDtoImpl <br/>
 * Date:     2016年8月16日 上午10:31:26 <br/>
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class AppTagsMaskingDaoImpl extends BaseDao implements AppTagsMaskingDao {

    @Override
    public Integer countByTagsId(Long tagsId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("tagsId", tagsId);
        return selectOne("countByTagsId", map);
    }

    @Override
    public List<AppTagsMaskingEntity> findAllByTagsId(Long tagsId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("tagsId", tagsId);
        return selectList("findAllByTagsId", map);
    }

    @Override
    public void deleteByTagsId(Long tagsId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("tagsId", tagsId);
        delete("deleteByTagsId", map);
    }

    @Override
    public List<Long> findTagIdsByAppId(Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        return selectList("findTagIdsByAppId", map);
    }

    @Override
    public void deleteByAppId(Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        delete("deleteByAppId", map);
    }
    
    @Override
    public void insert(AppTagsMaskingEntity appTagsMaskingEntity){
        appTagsMaskingEntity.setGmtCreate(new Date());
        appTagsMaskingEntity.setGmtModified(new Date());
        insert("insert", appTagsMaskingEntity);
    }
    
    @Override
    public AppTagsMaskingEntity find(Long id){
        return selectOne("find", id);
    }
    
    @Override
    public void update(AppTagsMaskingEntity appTagsMaskingEntity){
        appTagsMaskingEntity.setGmtModified(new Date());
        update("update", appTagsMaskingEntity);
    }
}

