package cn.com.duiba.developer.center.biz.dao.applayout.impl;

import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import cn.com.duiba.developer.center.biz.dao.applayout.AppLayoutBrickDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.base.Optional;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/27.
 */
@Repository
public class AppLayoutBrickDaoImpl extends BaseDao implements AppLayoutBrickDao {

    @Override
    public List<AppLayoutBrickDO> getAllSystemLayoutBrickList(PageQueryEntity params) {
        return selectList("getAllSystemLayoutBrickList", params);
    }

    @Override
    public Integer getSystemThemeLayoutPageCount(PageQueryEntity params) {
        return selectOne("getSystemThemeLayoutPageCount",params);
    }

    @Override
    public List<AppLayoutBrickDO> getCustomThemeLayoutList(PageQueryEntity params) {
        return selectList("getCustomThemeLayoutList", params);
    }

    @Override
    public Integer getCustomThemeLayoutCount(PageQueryEntity params) {
        return selectOne("getCustomThemeLayoutCount", params);
    }

    //****************************以下未迁移***************************************

    @Override
    public AppLayoutBrickDO findWithSimple(Long id) {
        return this.selectOne("findWithSimple", id);
    }

    @Override
    public int insert(AppLayoutBrickDO appLayoutBrick){
        return insert("insert", appLayoutBrick);
    }

    @Override
    public List<AppLayoutBrickDO> findAllShowSystemBrickWithSimple(){
        return selectList("findAllShowSystemBrickWithSimple");
    }

    @Override
    public List<AppLayoutBrickDO> findDingzhiThemeWithSimple(Long appId){
        return selectList("findDingzhiThemeWithSimple",appId);
    }

    @Override
    public String getBrickContentById(Long brickId) {
        return selectOne("getBrickContentById",brickId);
    }

    public int updateLayoutBrickPayload(Optional<Long> id, Optional<Integer> payload){
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("id", id.get());
        param.put("payload", payload.get());
        return update("updateLayoutBrickPayload", param);
    }

    public int updateLayoutBrickShowStatus(Optional<Long> id,Optional<Integer> status){
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("id", id.get());
        param.put("status", status.get());
        return update("updateLayoutBrickShowStatus", param);
    }

    public int updateBrick(AppLayoutBrickDO brick){
        return update("updateBrick", brick);
    }

    public int updateBrickDelete(Optional<Long> id){
        return update("updateBrickDelete", id.get());
    }
}
