package cn.com.duiba.developer.center.biz.dao.applayout.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.developer.center.biz.dao.applayout.AppLayoutDao;
import cn.com.duiba.developer.center.biz.entity.AppLayoutEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

import com.google.common.collect.Maps;

/**
 * Created by liuyao on 16/7/29.
 */
@Repository
public class AppLayoutDaoImpl extends BaseDao implements AppLayoutDao {

    @Override
    public int insert(AppLayoutEntity appLayout){
        return insert("insert", appLayout);
    }
    @Override
    public AppLayoutEntity findByAppId(Long appId){
        return selectOne("findByAppId",appId);
    }

    @Override
    public int updateColor(Long appId, String color) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId", appId);
        params.put("color",color);
        return update("updateColor", params);
    }

    @Override
    public int updateSkinId(Long appId, Long skinId) {
        Map<String,Long> params = new HashMap<String,Long>();
        params.put("appId",appId);
        params.put("skinId",skinId);
        return update("updateSkinId",params);
    }

    @Override
    public int updateDevelopSortJsonByAppId(Long appId,String json) {
        Map<String,Object> params=Maps.newHashMap();
        params.put("appId",appId);
        params.put("json",json);
        return update("updateDevelopSortJsonByAppId",params);
    }

    @Override
    public int updateDevelopDataShowJsonByAppId(Long appId,String json) {
        Map<String,Object> params=Maps.newHashMap();
        params.put("appId",appId);
        params.put("json",json);
        return update("updateDevelopDataShowJsonByAppId",params);
    }

    @Override
    public Integer useSkinCount(Long skinId){
        return selectOne("useSkinCount",skinId);
    }

    @Override
    public int initFloorConfig(Long appId, String developSortJson, String developDataShowJson) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId",appId);
        params.put("developSortJson",developSortJson);
        params.put("developDataShowJson",developDataShowJson);

        return update("initFloorConfig",params);
    }

    @Override
    public Collection<Long> useSkinAppIds(Long skinId) {
        return selectList("useSkinAppIds",skinId);
    }

}
