package cn.com.duiba.developer.center.biz.dao.center_config;

import cn.com.duiba.developer.center.api.domain.paramquery.AppAerosolParams;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.entity.AerosolEntity;
import cn.com.duiba.developer.center.biz.entity.AerosolGroupEntity;
import cn.com.duiba.developer.center.biz.service.credits.aerosol.pojo.AerosolCount;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;


import java.util.*;


/**
 * Created by liuyao on 16/9/8.
 */
@Repository
public class AerosolDao extends BaseDao{

    public AerosolEntity findByAppId(Long appId) {
        return selectOne("findByAppId", appId);
    }

    public List<AerosolEntity> findByAppIds(List<Long> appIds){
        Map<String,Object> params = Maps.newHashMap();
        params.put("appIds",appIds);
        return selectList("findByAppIds",params);
    }

    public List<AerosolEntity> findByIds(List<Long> ids){
        Map<String,Object> params = Maps.newHashMap();
        params.put("ids",ids);
        return selectList("findByIds",params);
    }

    public int batchInsert(List<AerosolEntity> list){
        return insert("batchInsert",list);
    }

    /**
     * 将已经存在的浮标归到指定的浮标组
     * @param appIds
     * @param groupId
     * @param isShow
     */
    public int batchComeToAerosol(List<Long> appIds,Long groupId,Boolean isShow){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("appIds",appIds);
        params.put("groupId",groupId);
        params.put("isShow",isShow);
        return update("batchComeToAerosol", params);
    }

    /**
     * 加载组详情时,加载组下面的所有App
     * @param groupId
     * @return
     */
    public List<AerosolEntity> findAerosolByGroupId(Long groupId){
        return selectList("findAerosolByGroupId",groupId);
    }

    /**
     * 批量更新
     * @param appIds 批量更新的应用Id
     * @param aerosol 更新的内容,只会取MD5和配置链接
     * @return 更新条数
     */
    public int batchUpdateAerosol(List<Long> appIds,AerosolEntity aerosol){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("appIds",appIds);
        params.put("md5",aerosol.getMd5());
        params.put("configUrl",aerosol.getConfigUrl());
        return update("batchUpdateAerosol",params);
    }

    public int deleteAerosolByAppIds(List<Long> appIds){
        if(appIds==null || appIds.isEmpty()){
            return 0;
        }
        Map<String,Object> params = Maps.newHashMap();
        params.put("appIds",appIds);
        return delete("deleteAerosolByAppIds",params);
    }


    public List<AerosolCount> findGroupCounts(List<Long> groupIds){
        Map<String,Object> params = Maps.newHashMap();
        params.put("groupIds",groupIds);
        return selectList("findGroupCounts",params);
    }

    public List<AerosolEntity> findAerosolPageList(AppAerosolParams params){
        if(StringUtils.isNotBlank(params.getGroupName()) && params.getGroupIds().isEmpty()){
            return Collections.emptyList();
        }
        return selectList("findAerosolPageList",params);
    }

    public Long findAerosolPageCount(AppAerosolParams params){
        if(StringUtils.isNotBlank(params.getGroupName()) && params.getGroupIds().isEmpty()){
            return 0L;
        }
        return selectOne("findAerosolPageCount",params);
    }

    public int updateAerosolShowByAppIds(List<Long> appIds,Boolean isShow){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("appIds",appIds);
        params.put("isShow",isShow);
        return update("updateAerosolShowByAppIds",params);
    }

    public int batchUpdateGroupIdToNullByAppIds(List<Long> appIds){
        Map<String,Object> params = Maps.newHashMap();
        params.put("appIds",appIds);
        return update("batchUpdateGroupIdToNullByAppIds",params);
    }
}
