package cn.com.duiba.developer.center.biz.dao.floor.impl;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeCopyDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorCodeCopyDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by suyuanlong on 16/8/17.
 */
@Repository
public class CreditsFloorCodeCopyDaoImpl  extends BaseDao implements CreditsFloorCodeCopyDao {
    @Override
    public int insertFloorCodeCopyList(List<CreditsFloorCodeCopyDto> dtoList) {
        return insert("insertFloorCodeCopyList",dtoList);
    }
    @Override
    public int deleteFloorCodeCopyList(Long skinId,Collection<Long> floorIds) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("skinId",skinId);
        params.put("floorIds",floorIds);
        return delete("deleteFloorCodeCopyList",params);
    }
    @Override
    public List<CreditsFloorCodeCopyDto> seletListBySkinIds(Collection<Long> skinIds) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("skinIds",skinIds);
        return selectList("seletListBySkinIds",params);
    }

    @Override
    public int updateFloorCodeCopy(CreditsFloorCodeCopyDto update) {
        return update("updateFloorCodeCopy",update);
    }
}
