package cn.com.duiba.developer.center.biz.dao.floor.impl;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorSkinDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by suyuanlong on 16/8/11.
 */
@Repository
public class CreditsFloorSkinDaoImpl extends BaseDao implements CreditsFloorSkinDao {

    @Override
    public CreditsFloorSkinDto insertFloorSkin(CreditsFloorSkinDto dto) {
        insert("insertFloorSkin", dto);
        return dto;
    }

    @Override
    public int updateFloorSkin(CreditsFloorSkinDto dto) {
        return update("updateFloorSkin", dto);
    }

    @Override
    public List<CreditsFloorSkinDto> selectFloorSkins(PageQueryEntity params) {
        return selectList("selectFloorSkins", params);
    }

    @Override
    public Integer selectFloorSkinsCount() {
        HashMap<String, Object> params = Maps.newHashMap();
        return selectOne("selectFloorSkinsCount", params);
    }

    @Override
    public CreditsFloorSkinDto selectFloorSkinById(Long id) {
        return selectOne("selectFloorSkinById", id);
    }

    @Override
    public CreditsFloorSkinDto selectFloorSkinForUpdate(Long id) {
        return selectOne("selectFloorSkinForUpdate",id);
    }

    @Override
    public int switchSkinSpecify(Long id, Boolean isOpen) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("id",id);
        params.put("isOpen",isOpen);
        return update("switchSkinSpecify",params);
    }

    @Override
    public int switchOpenState(Long id, Boolean isOpen) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("id",id);
        params.put("isOpen",isOpen);
        return update("switchOpenState",params);
    }

    @Override
    public List<CreditsFloorSkinDto> findDevCommonSkinList() {
        return selectList("findDevCommonSkinList");
    }

    @Override
    public List<CreditsFloorSkinDto> findDevSpecifySkinList(Collection<Long> ids) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("ids",ids);
        return selectList("findDevSpecifySkinList",params);
    }
}
