package cn.com.duiba.developer.center.biz.dao.floor.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorSkinSpecifyDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;

/**
 * Created by suyuanlong on 16/8/16.
 */
@Repository
public class CreditsFloorSkinSpecifyDaoImpl  extends BaseDao implements CreditsFloorSkinSpecifyDao {
    @Override
    public List<Long> selectSpecifyAppIdsBySkinId(Long skinId) {
        return selectList("selectSpecifyAppIdsBySkinId",skinId);
    }

    @Override
    public int findSkinOpenSpecifyCount(Long skinId) {
        return selectOne("findSkinOpenSpecifyCount",skinId);
    }

    @Override
    public int insertAppSpecify(Long appId, Long skinId) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId",appId);
        params.put("skinId",skinId);
        return insert("insertAppSpecify",params);
    }

    @Override
    public List<Long> selectSkinIdBySpecifyAppId(Long appId) {
        return selectList("selectSkinIdBySpecifyAppId",appId);
    }


}
