package cn.com.duiba.developer.center.biz.event;

import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import org.apache.commons.lang.StringUtils;

import javax.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Map;

/**
 * Created by liuyao on 16/8/19.
 */
public class FloorSkinCodeSynEvent{
    public FloorSkinCodeSynEvent(Long skinId,String floorsJsonArray){
        this.skinId = skinId;
        this.floorsJsonArray = floorsJsonArray;
    }
    @NotNull
    private Long skinId;
    @NotNull
    private String floorsJsonArray;//{id:业务楼层Id,syn:是否同步}

    public Map<Long,Boolean> getSynMap() throws BusinessException {
        if(StringUtils.isBlank(floorsJsonArray)) return Collections.emptyMap();
        JSONArray jsonArray = JSONArray.parseArray(floorsJsonArray);
        Map<Long,Boolean> synMap = Maps.newHashMap();
        for(int i=0;i<jsonArray.size();i++){
            JSONObject json = jsonArray.getJSONObject(i);
            if(!json.containsKey("id")) throw new BusinessException("楼层Id缺失");
            if(!json.containsKey("syn")) throw new BusinessException("楼层更新标记缺失");
            synMap.put(json.getLong("id"),json.getBoolean("syn"));
        }
        return synMap;
    }

    public String getFloorsJsonArray() {
        return floorsJsonArray;
    }

    public void setFloorsJsonArray(String floorsJsonArray) {
        this.floorsJsonArray = floorsJsonArray;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }
}
