package cn.com.duiba.developer.center.biz.remoteservice.floor;

import java.util.Collection;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeCopyDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteCreditsFloorCodeService;
import cn.com.duiba.developer.center.biz.bo.FloorBo;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeCopyService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class RemoteCreditsFloorCodeServiceImpl implements RemoteCreditsFloorCodeService {
    private static final Logger logger= LoggerFactory.getLogger(RemoteCreditsFloorCodeServiceImpl.class);

    @Autowired
    private CreditsFloorCodeService creditsFloorCodeService;
    @Autowired
    private FloorBo floorBo;
    @Autowired
    private CreditsFloorCodeCopyService creditsFloorCodeCopyService;

    @Override
    public DubboResult<CreditsFloorCodeDto> insertFloorCode(CreditsFloorCodeDto dto) {
        try {
            ValidatorTool.valid(dto);
            CreditsFloorCodeDto floorCodeDto=creditsFloorCodeService.insertFloorCode(dto);
            return DubboResult.successResult(floorCodeDto);

        }catch (Exception e){
             logger.error("新建楼层失败",e);
             return DubboResult.failResult(e.getMessage());
        }

    }

    @Override
    public  DubboResult<Integer> updateFloorCode(CreditsFloorCodeDto dto) {
        try{
            int ret= creditsFloorCodeService.updateFloorCode(dto);
            return DubboResult.successResult(ret);
        }catch (Exception e){
            logger.error("编辑楼层失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PaginationVO<JSONObject>> selectFloorCodesByType(FloorPageParams params) {
        try {
            PaginationVO<JSONObject> page= floorBo.getFloorPage(params);
            return DubboResult.successResult(page);
        }catch (Exception e){
            logger.error("加载楼层列表失败",e);
           return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public  DubboResult<CreditsFloorCodeDto> selectFloorCodeById(Long id) {

        try {
            CreditsFloorCodeDto dto=  creditsFloorCodeService.selectFloorCodeById(id);
            return DubboResult.successResult(dto);
        }catch (Exception e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<CreditsFloorCodeCopyDto>> seletCodeCopyListBySkinId(Long skinId) {
        try{
            List<CreditsFloorCodeCopyDto> list = creditsFloorCodeCopyService.seletListBySkinId(skinId);
            return DubboResult.successResult(list);
        }catch (Exception e){
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<CreditsFloorCodeDto>> getFloorCodeList(Collection<Long> ids) {
        try{
            List<CreditsFloorCodeDto> list = creditsFloorCodeService.selectFloorCodeList(ids);
            return DubboResult.successResult(list);
        }catch(Exception e){
            e.printStackTrace();
            return DubboResult.failResult(e.getMessage());
        }
    }
}
