package cn.com.duiba.developer.center.biz.remoteservice.floor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteShowcaseBackendService;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorShowcaseService;
import cn.com.duiba.wolf.dubbo.DubboResult;
/**
 * 楼层橱窗
 *<br/>
 * Author：zhengjy <br/>
 * Create Time：2016年10月14日 上午10:37:08
 */
@Service
public class RemoteShowcaseBackendServiceImpl implements RemoteShowcaseBackendService {
	
	@Autowired
	CreditsFloorShowcaseService creditseFloorShowcaseService;
	
	@Override
	public DubboResult<FloorShowcaseContentDto> getShowcaseContent(long appId,int place) {
		
		try {
            return DubboResult.successResult(creditseFloorShowcaseService.getShowcaseContent(appId, place));
        } catch (Exception e) {
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<Void> deleteShowcaseContent(long appId, int place) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DubboResult<Void> saveShowcaseContent(
			FloorShowcaseContentDto floorShowcaseContentDto) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DubboResult<Void> switchCountDown(long appId, int place,
			boolean enable) {
		// TODO Auto-generated method stub
		return null;
	}

}
