package cn.com.duiba.developer.center.biz.remoteservice.floor;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.ShowcaseDto;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.api.remoteservice.floor.RemoteShowcaseService;
import cn.com.duiba.developer.center.biz.bo.FloorBo;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorShowcaseService;
import cn.com.duiba.wolf.dubbo.DubboResult;


@Service
public class RemoteShowcaseServiceImpl implements RemoteShowcaseService {
	@Autowired
	CreditsFloorShowcaseService creditseFloorShowcaseService;
	@Autowired
	FloorBo floorBo;
	Logger log = Logger.getLogger(RemoteShowcaseServiceImpl.class);

	@Override
	public DubboResult<Boolean> saveShowcaseConfig(ShowcaseDto showcaseDto) {
		try{
			floorBo.saveShowcaseConfig(showcaseDto);
			return DubboResult.successResult(true);
		}catch(Exception e){
			log.error("saveShowcaseConfig showcaseDto="+showcaseDto,e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> delShowcaseConfig(Long appId, Integer place) {
		try{
			floorBo.delShowcaseConfig(appId,place);
			return DubboResult.successResult(true);
		}catch(Exception e){
			log.error("delShowcaseConfig failed,appId="+appId+" place="+place,e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<FloorShowcaseContentDto>> getShowcaseList(long appId) {
		try{
			return DubboResult.successResult(floorBo.getShowcaseList(appId));
		}catch(Exception e){
			log.error("getShowcaseList appId="+appId, e);
			return DubboResult.failResult(e.getMessage());
			
		}



		
	}

}
