package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAmbDeveloperWithdrawCashOrderService;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashOrderService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by ZQian on 2016/8/9.
 */
@Service
public class RemoteAmbDeveloperWithdrawCashOrderServiceImpl implements RemoteAmbDeveloperWithdrawCashOrderService {

    @Autowired
    private AmbDeveloperWithdrawCashOrderService ambDeveloperWithdrawCashOrderService;

    @Override
    public DubboResult<AmbDeveloperWithdrawCashOrderDto> insert(AmbDeveloperWithdrawCashOrderDto ambDeveloperWithdrawCashOrderDto) {
        ambDeveloperWithdrawCashOrderService.insert(ambDeveloperWithdrawCashOrderDto);
        return DubboResult.successResult(ambDeveloperWithdrawCashOrderDto);
    }

    @Override
    public DubboResult<List<AmbDeveloperWithdrawCashOrderDto>> findCashOrderList(Map<String, Object> queryPamas) {
        return DubboResult.successResult(ambDeveloperWithdrawCashOrderService.findCashOrderList(queryPamas));
    }

    @Override
    public DubboResult<Long> findCashOrderCount(Map<String, Object> queryPamas) {
        return DubboResult.successResult(ambDeveloperWithdrawCashOrderService.findCashOrderCount(queryPamas));
    }

    @Override
    public DubboResult<Integer> updateStatusCreateToWaitPay(Long cashOrderId) {
        return DubboResult.successResult(ambDeveloperWithdrawCashOrderService.updateStatusCreateToWaitPay(cashOrderId));
    }

    @Override
    public DubboResult<Integer> updateStatusCreateToFail(Long cashOrderId) {
        return DubboResult.successResult(ambDeveloperWithdrawCashOrderService.updateStatusCreateToFail(cashOrderId));
    }

    @Override
    public DubboResult<Integer> updateStatusCreateToSuccess(Long cashOrderId) {
        return DubboResult.successResult(ambDeveloperWithdrawCashOrderService.updateStatusCreateToSuccess(cashOrderId));
    }
}
