/**
 * Project Name:developer-center-biz File Name:RemoteAppBannerServiceImpl.java Package
 * Name:cn.com.duiba.developer.center.biz.remoteservice.impl Date:2016年8月10日下午8:51:58 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.remoteservice.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AppBannerDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppBannerServiceNew;
import cn.com.duiba.developer.center.biz.entity.AppBannerEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppBannerService;
import cn.com.duiba.developer.center.common.tools.AppLogUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;

/**
 * ClassName:RemoteAppBannerServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年8月10日 下午8:51:58 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteAppBannerServiceNewImpl implements RemoteAppBannerServiceNew {

    private static Logger    log = LoggerFactory.getLogger(RemoteAppBannerServiceNewImpl.class);

    @Autowired
    private AppBannerService appBannerService;

    @Override
    public DubboResult<AppBannerDto> find(Long id) {
        try {
            AppBannerEntity entity = appBannerService.find(id);
            AppBannerDto dto = new AppBannerDto();
            ObjectUtil.convert(entity, dto);
            return DubboResult.successResult(dto);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appBannerService.find failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateByIdAndAppId(AppBannerDto appBanner) {
        try {
            AppBannerEntity entity = new AppBannerEntity();
            ObjectUtil.convert(appBanner, entity);
            Integer ret = appBannerService.updateByIdAndAppId(entity);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appBannerService.update failed, appbanner={}", appBanner, e);
            return DubboResult.failResult(e.getMessage());

        }
    }

    @Override
    public DubboResult<Void> insert(AppBannerDto appBanner) {
        try {
            AppBannerEntity entity = new AppBannerEntity();
            ObjectUtil.convert(appBanner, entity);
            appBannerService.insert(entity);
            appBanner.setId(entity.getId());
            return DubboResult.successResult(null);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appBannerService.insert failed, appbanner={}", appBanner, e);
            return DubboResult.failResult(e.getMessage());

        }
    }

    @Override
    public DubboResult<Integer> findMaxPlayload(Long appId, String type) {
        try {
            Integer maxPayload = appBannerService.findMaxPlayload(appId, type);
            return DubboResult.successResult(maxPayload);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appBannerService.findMaxPlayload failed, appId={}, type={}", appId, type, e);
            return DubboResult.failResult(e.getMessage());

        }
    }

    @Override
    public DubboResult<List<AppBannerDto>> findAllByAppId(Long appId, Boolean deleted) {
        try {
            List<AppBannerEntity> entityList = appBannerService.findAllByAppId(appId, deleted);
            return DubboResult.successResult(convertToAppBannerDto(entityList));
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appBannerService.findAllByAppId failed, appId={}", appId, e);
            return DubboResult.failResult(e.getMessage());

        }
    }

    @Override
    public DubboResult<List<AppBannerDto>> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted) {
        try {
            List<AppBannerEntity> entityList = appBannerService.findAllByAppIdDeleteAndType(appId, type, deleted);
            return DubboResult.successResult(convertToAppBannerDto(entityList));
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appBannerService.findAllByAppIdDeleteAndType failed, appId={}, type={}",
                             appId, type, e);
            return DubboResult.failResult(e.getMessage());

        }
    }

    @Override
    public DubboResult<Void> sortByBannerIdAndRange(Long appId, Long bannerId, String type, Integer startPayload,
                                                    Integer endPayload) {
        // startPayload == endPayload说明banner没有移动，直接返回成功
        if (Objects.equal(startPayload, endPayload)) {
            return DubboResult.successResult(null);
        }
        try {
            List<AppBannerEntity> entityList = appBannerService.findListBetweenPayload(appId, type, startPayload,
                                                                                       endPayload);
            AppBannerEntity updateEntity = new AppBannerEntity();
            updateEntity.setAppId(appId);
            for (AppBannerEntity entity : entityList) {
                updateEntity.setId(entity.getId());
                // 被移动的banner直接更新为endPayload
                if (Objects.equal(entity.getId(), bannerId)) {
                    updateEntity.setPayload(endPayload);
                } else {
                    // 如果向下移动，区间内的banner权重值+1
                    if (startPayload > endPayload) {
                        updateEntity.setPayload(entity.getPayload() + 1);
                    } else {
                        // 如果向上移动，区间内的banner权重值-1
                        updateEntity.setPayload(entity.getPayload() - 1);
                    }
                }
                appBannerService.updateByIdAndAppId(updateEntity);
            }
            return DubboResult.successResult(null);
        } catch (Exception e) {
            AppLogUtil.error(log,
                             "invoke appBannerService.sortByBannerIdAndRange failed, appId={}, bannerId={}, type={}",
                             appId, bannerId, type, e);
            return DubboResult.failResult(e.getMessage());

        }
    }

    @Override
    public DubboResult<List<AppBannerDto>> findBannerByItemId(Long appId, Long appItemId, String type) {
        try {
            List<AppBannerEntity> entityList = appBannerService.findBannerByItemId(appId, appItemId, type);
            return DubboResult.successResult(convertToAppBannerDto(entityList));
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appBannerService.findBannerByItemId failed, appId={}, type={}", appId, type,
                             e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    private List<AppBannerDto> convertToAppBannerDto(List<AppBannerEntity> entityList) {
        return Lists.transform(entityList, new Function<AppBannerEntity, AppBannerDto>() {

            @Override
            public AppBannerDto apply(AppBannerEntity input) {
                AppBannerDto dto = new AppBannerDto();
                ObjectUtil.convert(input, dto);
                return dto;
            }
        });
    }
}
