package cn.com.duiba.developer.center.biz.service.credits;

import cn.com.duiba.developer.center.api.domain.dto.CenterConfigDto;
import cn.com.duiba.developer.center.api.domain.enums.CenterConfigEnum;
import cn.com.duiba.developer.center.biz.dao.center_config.CenterConfigDao;
import cn.com.duiba.developer.center.biz.entity.CenterConfigEntity;
import cn.com.duiba.developer.center.common.support.Environment;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuyao on 16/9/8.
 */
@Service
public class CenterConfigService {

    private final static String CACHE_KEY = "dcm_key_center_config_";

    @Autowired
    private CacheClient memcachedClient;

    @Autowired
    private CenterConfigDao centerConfigDao;

    public CenterConfigDto findByType(CenterConfigEnum type) {
        String key = getKey(type.getType());
        CenterConfigDto config = memcachedClient.get(key);
        if(config == null){
            CenterConfigEntity entity = centerConfigDao.findByType(type);
            config = new CenterConfigDto();
            try {
                BeanUtils.copyProperties(config,entity);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            if(!Environment.isDev()){
                memcachedClient.set(key,config,60);
            }

        }
        return config;
    }

    private String getKey(String type){
        StringBuilder sb = new StringBuilder();
        sb.append(CACHE_KEY).append(type);
        return sb.toString();
    }

}
