package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorCodeDao;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by suyuanlong on 16/8/10.
 */
@Service
public class CreditsFloorCodeServiceImpl implements CreditsFloorCodeService{

    @Autowired
    private CreditsFloorCodeDao creditsFloorCodeDao;
    @Override
    public CreditsFloorCodeDto insertFloorCode(CreditsFloorCodeDto dto) {
        CreditsFloorCodeDto floor= creditsFloorCodeDao.insertFloorCode(dto);
        return floor;
    }

    @Override
    public int updateFloorCode(CreditsFloorCodeDto dto) {
        int ret= creditsFloorCodeDao.updateFloorCode(dto);
        return ret;
    }

    @Override
    public PaginationVO<CreditsFloorCodeDto> selectFloorCodesByType(FloorPageParams params) {

        int count=creditsFloorCodeDao.selectFloorCodesCountByType(params);
        List<CreditsFloorCodeDto> list=creditsFloorCodeDao.selectFloorCodesByType(params);

        PaginationVO<CreditsFloorCodeDto> pv=new PaginationVO<CreditsFloorCodeDto>();
        pv.setRows(list);
        pv.setTotalCount(Long.valueOf(count));
        return pv;
    }

    @Override
    public CreditsFloorCodeDto selectFloorCodeById(Long id) {
        return creditsFloorCodeDao.selectFloorCodeById(id);
    }

    @Override
    public List<CreditsFloorCodeDto> selectFloorCodeList(Collection<Long> ids) {
        if(ids.isEmpty()) return Collections.emptyList();
        return creditsFloorCodeDao.selectFloorCodeList(new ArrayList<Long>(ids));
    }
}
