package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import java.util.List;
import java.util.Objects;

import cn.com.duiba.developer.center.biz.bo.impl.AppLayoutBoImpl;
import cn.com.duiba.developer.center.biz.event.FloorSkinUpdateEvent;
import cn.com.duiba.developer.center.common.support.BizEventBus;

import cn.com.duiba.service.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorSkinDao;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * Created by suyuanlong on 16/8/11.
 */
@Service
public class CreditsFloorSkinServiceImpl implements CreditsFloorSkinService {
    private static final Logger log= LoggerFactory.getLogger(CreditsFloorSkinServiceImpl.class);
    @Autowired
    private CreditsFloorSkinDao creditsFloorSkinDao;

    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private BizEventBus eventBus;

    @Override
    public CreditsFloorSkinDto insertFloorSkin(CreditsFloorSkinDto dto) {
        return creditsFloorSkinDao.insertFloorSkin(dto);
    }

    @Override
    public int updateFloorSkin(CreditsFloorSkinDto dto){
        int ret = creditsFloorSkinDao.updateFloorSkin(dto);
        removeCacheById(dto.getId());
        return ret;
    }

    @Override
    public PaginationVO<CreditsFloorSkinDto> selectFloorSkins(FloorPageParams params) {
        PaginationVO page=new PaginationVO();
        Integer total=creditsFloorSkinDao.selectFloorSkinsCount();
        List<CreditsFloorSkinDto> list=creditsFloorSkinDao.selectFloorSkins(params);
        page.setRows(list);
        page.setTotalCount(Long.valueOf(total));
        return page;
    }

    @Override
    public CreditsFloorSkinDto selectFloorSkinById(Long id) {
        if(Objects.equals(null,id)) throw new RuntimeException("楼层皮肤查询Id缺失");
        /**此处 用到缓存，加快皮肤 展示 速度 **/
        CreditsFloorSkinDto skin = memcachedClient.get(getSkinIdKey(id));
        if(Objects.equals(null,skin)) {
            skin = creditsFloorSkinDao.selectFloorSkinById(id);
            if(skin!=null) {
                memcachedClient.set(getSkinIdKey(id), skin, 300);
            }
        }
        return skin;
    }

    @Override
    public CreditsFloorSkinDto selectFloorSkinForUpdate(Long id) {
        return creditsFloorSkinDao.selectFloorSkinForUpdate(id);
    }

    @Override
    public int switchSkinSpecify(Long id, Boolean isOpen) {
        int res =creditsFloorSkinDao.switchSkinSpecify(id,isOpen);
        removeCacheById(id);
        return res;
    }

    @Override
    public int switchOpenState(Long id,Boolean isOpen) {//改变状态不影响手机展示,所以不更新缓存
        creditsFloorSkinDao.switchOpenState(id,isOpen);
        removeCacheById(id);
        return isOpen?1:0;
    }


    @Override
    public List<CreditsFloorSkinDto> findDevSkinList(List<Long> specifySkinIds) {
        //1.获取所有非定向的楼层皮肤
        List<CreditsFloorSkinDto> list = creditsFloorSkinDao.findDevCommonSkinList();

        if(CollectionUtils.isNotEmpty(specifySkinIds)){
            List<CreditsFloorSkinDto> specifyList = creditsFloorSkinDao.findDevSpecifySkinList(specifySkinIds);
            list.addAll(specifyList);
        }
        return list;
    }

    private String getSkinIdKey(Long id){
        StringBuilder sb = new StringBuilder();
        sb.append(CacheConstants.KEY_FLOOL_SKIN_ID).append(id);
        return sb.toString();
    }

    private void removeCacheById(Long id){
        FloorSkinUpdateEvent event = new FloorSkinUpdateEvent(id);
        try{
            memcachedClient.remove(getSkinIdKey(id));
            eventBus.post(event);
        }catch(Exception e){
            log.error("清除楼层皮肤缓存失败",e);
        }

    }
}
