package cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig;

import cn.com.duiba.developer.center.api.domain.enums.ChildPageTargetEnum;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * Created by liuyao on 16/8/23.
 * 活动子页面
 */
public class ActivityJson extends BaseJson {
    /** 楼层标题 */
    @NotNull
    @Length(max = 8)
    private String floorTitle;//楼层标题

    /** 点击后跳转目标 {@see ChildPageTargetEnum} */
    @NotNull
    private String target = ChildPageTargetEnum.GO_TO_SUB_PAGE.getCode();//点击后跳转目标
    /** 是否展示活动积分 */
    @NotNull
    private Boolean showCredits = true;
    /** 是否展示活动标题 */
    @NotNull
    private Boolean showTitle = true;
    /** 是否展示角标 */
    @NotNull
    private Boolean showCustomTag = true;

    public String getFloorTitle() {
        return floorTitle;
    }

    public void setFloorTitle(String floorTitle) {
        this.floorTitle = floorTitle;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Boolean getShowCredits() {
        return showCredits;
    }

    public void setShowCredits(Boolean showCredits) {
        this.showCredits = showCredits;
    }

    public Boolean getShowTitle() {
        return showTitle;
    }

    public void setShowTitle(Boolean showTitle) {
        this.showTitle = showTitle;
    }

    public Boolean getShowCustomTag() {
        return showCustomTag;
    }

    public void setShowCustomTag(Boolean showCustomTag) {
        this.showCustomTag = showCustomTag;
    }
}
