package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.developer.center.biz.dao.developer.AmbDeveloperWithdrawCashOrderDao;
import cn.com.duiba.developer.center.biz.entity.AmbDeveloperWithdrawCashOrderEntity;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashOrderService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by ZQian on 2016/8/9.
 */
@Service
public class AmbDeveloperWithdrawCashOrderServiceImpl implements AmbDeveloperWithdrawCashOrderService {

    @Autowired
    private AmbDeveloperWithdrawCashOrderDao ambDeveloperWithdrawCashOrderDao;

    @Override
    public void insert(AmbDeveloperWithdrawCashOrderDto ambDeveloperWithdrawCashOrderDto) {
        AmbDeveloperWithdrawCashOrderEntity entity = BeanUtils.copy(ambDeveloperWithdrawCashOrderDto, AmbDeveloperWithdrawCashOrderEntity.class);
        ambDeveloperWithdrawCashOrderDao.insert(entity);
        ambDeveloperWithdrawCashOrderDto.setId(entity.getId());
    }

    @Override
    public List<AmbDeveloperWithdrawCashOrderDto> findCashOrderList(Map<String, Object> queryPamas) {
        return BeanUtils.copyList(ambDeveloperWithdrawCashOrderDao.findCashOrderList(queryPamas),AmbDeveloperWithdrawCashOrderDto.class);
    }

    @Override
    public Long findCashOrderCount(Map<String, Object> queryPamas) {
        return ambDeveloperWithdrawCashOrderDao.findCashOrderCount(queryPamas);
    }

    @Override
    public int updateStatusCreateToWaitPay(Long cashOrderId) {
        return ambDeveloperWithdrawCashOrderDao.updateStatusCreateToWaitPay(cashOrderId);
    }

    @Override
    public int updateStatusCreateToFail(Long cashOrderId) {
        return ambDeveloperWithdrawCashOrderDao.updateStatusCreateToFail(cashOrderId);
    }

    @Override
    public int updateStatusCreateToSuccess(Long cashOrderId) {
        return ambDeveloperWithdrawCashOrderDao.updateStatusCreateToSuccess(cashOrderId);
    }
}
