package cn.com.duiba.developer.center.biz.service.credits.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.biz.dao.developer.DeveloperAccountDao;
import cn.com.duiba.developer.center.biz.entity.ManualChargeApplyEntity;
import cn.com.duiba.developer.center.biz.entity.RechargeOrdersEntity;
import cn.com.duiba.developer.center.biz.entity.RemainingMoneyEntity;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperAccountService;

@Service
public class DeveloperAccountServiceImpl implements DeveloperAccountService {
	
	@Autowired
	private DeveloperAccountDao developerAccountDao;

	@Override
	public Long addRechargeOrder(RechargeOrdersEntity order){
		return developerAccountDao.insertRechargeOrder(order);
	}

	@Override
	public RemainingMoneyEntity findDeveloperRemainingMoney(Long developerId) {
		return developerAccountDao.selectDeveloperRemainingMoney(developerId);
	}

	@Override
	public RechargeOrdersEntity findRechargeOrder(Long orderId) {
		return developerAccountDao.selectRechargeOrder(orderId);
	}

	@Override
	public Long updateRechargeOrder(RechargeOrdersEntity ro) {
		return developerAccountDao.updateRechargeOrder(ro);
	}

	@Override
	public Long saveManualChargeApply(ManualChargeApplyEntity mca) {
		return developerAccountDao.insertManualChargeApply(mca);
	}

	@Override
	public Long updateManualChargeApply(ManualChargeApplyEntity mca) {
		return developerAccountDao.updateManualChargeApply(mca);
	}

	@Override
	public RechargeOrdersEntity findByOrderNum(String orderNum) {
		return developerAccountDao.selectByOrderNum(orderNum);
	}

}
