package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.biz.dao.developer.SupplierProductsDao;
import cn.com.duiba.developer.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.developer.center.biz.service.credits.SupplierProductsService;

@Service
public class SupplierProductsServiceImpl implements SupplierProductsService{
	@Autowired
	private SupplierProductsDao supplierProductsDao;
	
	@Override
	public SupplierProductEntity findBySupplier(String supplier) {
		return supplierProductsDao.selectBySupplier(supplier);
	}

	@Override
	public List<SupplierProductEntity> findAllBySupplier(String supplier) {
		return supplierProductsDao.selectAllBySupplier(supplier);
	}

	@Override
	public SupplierProductEntity findBySupplierAndProductId(String supplier,
			String productId) {
		return supplierProductsDao.selectBySupplierAndProductId(supplier, productId);
	}

	@Override
	public List<SupplierProductEntity> findBySupplierAndFacePrice(
			String supplier, Integer facePrice) {
		return supplierProductsDao.selectBySupplierAndFacePrice(supplier, facePrice);
	}

	@Override
	public List<SupplierProductEntity> findBySupplierAndMobileAndProvince(
			String supplier, String mobile, String province) {
		return supplierProductsDao.selectBySupplierAndMobileAndProvince(supplier, mobile, province);
	}

	@Override
	public List<SupplierProductEntity> findAllBySupplierOrderByNameAndFacePrice(
			String supplier) {
		return supplierProductsDao.selectAllBySupplierOrderByNameAndFacePrice(supplier);
	}

	@Override
	public List<SupplierProductEntity> findAllBySupplierOrderByProvinceAndFacePrice(
			String supplier) {
		return supplierProductsDao.selectAllBySupplierOrderByProvinceAndFacePrice(supplier);
	}

	@Override
	public List<SupplierProductEntity> findAllBySupplierAndGameId(
			String supplier, String gameId) {
		return supplierProductsDao.selectAllBySupplierAndGameId(supplier, gameId);
	}

	@Override
	public List<SupplierProductEntity> findAllByIds(List<Long> ids) {
		return supplierProductsDao.selectAllByIds(ids);
	}

	@Override
	public void insert(SupplierProductEntity supplierProductEntity) {
		supplierProductsDao.insert(supplierProductEntity);
	}

	@Override
	public void update(SupplierProductEntity SupplierProductEntity) {
		supplierProductsDao.update(SupplierProductEntity);
	}

	@Override
	public SupplierProductEntity find(Long id) {
		return supplierProductsDao.select(id);
	}

	

}
