/**
 * Project Name:developer-center-biz File Name:TagsServiceImpl.java Package
 * Name:cn.com.duiba.developer.center.biz.service.credits.impl Date:2016年8月16日上午10:52:12 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.biz.dao.app.AppTagsMaskingDao;
import cn.com.duiba.developer.center.biz.dao.app.TagsDao;
import cn.com.duiba.developer.center.biz.entity.AppTagsMaskingEntity;
import cn.com.duiba.developer.center.biz.entity.TagEntity;
import cn.com.duiba.developer.center.biz.service.credits.TagsService;

/**
 * ClassName:TagsServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年8月16日 上午10:52:12 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class TagsServiceImpl implements TagsService {

    @Autowired
    private AppTagsMaskingDao appTagsMaskingDao;

    @Autowired
    private TagsDao           tagsDao;

    @Override
    public List<TagEntity> findAllTags() {
        return tagsDao.findAll();
    }

    @Override
    public List<Long> findShieldTagsByAppId(Long appId) {
        return appTagsMaskingDao.findTagIdsByAppId(appId);
    }

    @Override
    public void deleteTagMaskingByAppId(Long appId) {
        
        appTagsMaskingDao.deleteByAppId(appId);
        
    }

    @Override
    public void insertTagMasking(AppTagsMaskingEntity appTagsMaskingEntity) {
        appTagsMaskingDao.insert(appTagsMaskingEntity);
    }

}
