package cn.com.duiba.developer.center.biz.service.statistics;

import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppItemDwmStatDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppItemWeekMonthStatDto;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface OdpsAppItemDwmStatService {

	/**
	 * 根据appId和开始日期，结束日期，查询
	 */
	public List<OdpsAppItemDwmStatDto> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay);

	/**
	 * 根据appId和开始日期，结束日期，查询周月
	 */
	public OdpsAppItemWeekMonthStatDto findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, Long relationId, Integer relationType);
	
	
	
	/**
	 * 根据appId和开始日期，结束日期
	 */
	public List<OdpsAppItemDwmStatDto> findSumByAppIdAndDayAndOrderBy(Map<String, Object> params);
	
	/**
	 * 根据appId和开始日期，结束日期
	 */
	public List<OdpsAppItemDwmStatDto> findSumByAppIdAndDayAndIdAndTypeAndOrderBy(Map<String, Object> params);
	
	
	public List<OdpsAppItemWeekMonthStatDto> findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, List<Long> relationIds, Integer relationType);
}
