package cn.com.duiba.developer.center.biz.service.statistics.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.CreditsDistributionDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppCreditsDistributionDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.developer.center.biz.dao.statistics.OdpsAppCreditsDistributionDao;
import cn.com.duiba.developer.center.biz.entity.statistics.OdpsAppCreditsDistributionEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.statistics.OdpsAppCreditsDistributionService;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/8/2.
 */
@Service
public class OdpsAppCreditsDistributionServiceImpl implements OdpsAppCreditsDistributionService {
    @Resource
    private OdpsAppCreditsDistributionDao odpsAppCreditsDistributionDao;

    @Autowired
    private AppService appService;

    @Override
    public OdpsAppCreditsDistributionDto findAppCreditsDistributionByAppIdAndDay(Long appId, String day) {
        return BeanUtils.copy(odpsAppCreditsDistributionDao.findAppCreditsDistributionByAppIdAndDay(appId, day), OdpsAppCreditsDistributionDto.class);
    }

    @Override
    public List<CreditsDistributionDto> getAppCreditsDistributionByAppIdAndDay(Long appId, Date day) {

        OdpsAppCreditsDistributionDto stat = this.findAppCreditsDistributionByAppIdAndDay(appId, DateUtils.getDayStr(day));
        if(stat == null){
            AppSimpleDto app = appService.getObject(appId);
            stat = new OdpsAppCreditsDistributionDto(appId, Long.parseLong(app.getCreditsRate().toString()),0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,day);
        }
        List<CreditsDistributionDto> result = stat.getCreditsDistribution();
        return result;
    }
}
