package cn.com.duiba.developer.center.biz.bo;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import cn.com.duiba.developer.center.api.domain.dto.AppBulletinDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.service.credits.AppBulletinService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.service.exception.BusinessException;

/**
 * Created by liuyao on 16/9/10.
 */
@Service
public class AppBulletinBo {
    private static final Logger logger= LoggerFactory.getLogger(AppBulletinBo.class);
    @Autowired
    private AppService appService;
    @Autowired
    private AppBulletinService appBulletinService;

    private Cache<Long,AppBulletinDto> appBulletinCache = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build();

    public AppBulletinDto getAppBulletin(Long appId){

        LoadAppBulletin load = new LoadAppBulletin();
        load.setAppId(appId);
        try{
            return appBulletinCache.get(appId,load);
        }catch(Exception e){
            logger.info("未加载到app的公告",e);
            return new AppBulletinDto(false);
        }
    }

    private class LoadAppBulletin implements Callable<AppBulletinDto>{

        private Long appId;

        @Override
        public AppBulletinDto call(){
            try {
                AppSimpleDto app = appService.getObject(appId);
                if(app==null) throw new BusinessException("app不存在");
                if(!app.isAppSwitch(AppSimpleDto.SwitchOpenBulletin)){
                    return new AppBulletinDto(false);
                }
                AppBulletinDto dto = appBulletinService.createAppBulletinDto(appId);
                if(dto==null) throw new BusinessException("App首页公告配置不存在");
                return dto;
            }catch (Exception e){
                logger.error("首页加载失败",e);
                return new AppBulletinDto(false);
            }
        }

        public Long getAppId() {
            return appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }
    }


    public String getdetailText(Long appId){
        return appBulletinService.findContextByAppId(appId);
    }
}
