package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.common.tools.DateUtil;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import net.rubyeye.xmemcached.MemcachedClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * Created by liuyao on 2016/9/28.
 */
@Service
public class AppTradingLimitBo {

    private final String APP_NAMESPACE = "app_trading";

    @Autowired
    private CacheClient memcachedClient;

    public void addTrading(Long appId) {
        String key = getKey(appId);
        memcachedClient.incr(key,1,1,DateUtil.getToTomorrowSeconds(), TimeUnit.SECONDS);
    }

    public Integer getTodayTradingCount(Long appId) {
        String key = getKey(appId);
        Integer count = (Integer) memcachedClient.get(key);
        if(Objects.equals(null,count)){
            return 0;
        }else{
            return count;
        }
    }

    public void resetTodayTradingCount(Long appId) {
        String key = getKey(appId);
        memcachedClient.remove(key);
    }

    private String getKey(Long appId){
        StringBuilder sb = new StringBuilder();
        sb.append(APP_NAMESPACE).append(appId);
        return sb.toString();
    }
}
