package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.api.domain.dto.ShowcaseDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.service.exception.BusinessException;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;

import java.util.List;

/**
 * Created by liuyao on 16/8/16.
 */
public interface FloorBo {

    public PaginationVO<JSONObject> getFloorPage(FloorPageParams params) throws BusinessException;

    public CreditsFloorSkinDto insertFloorSkin(Optional<CreditsFloorSkinDto> dtoOpt) throws BusinessException;

    public int updateFloorSkin(Optional<CreditsFloorSkinDto> dtoOpt) throws BusinessException;

    public PaginationVO<JSONObject> getSkinPage(FloorPageParams params);

    public JSONObject getOneSkinConfig(Long id) throws BusinessException;

    public boolean switchSkinSpecify(Long id, Boolean isOpen) throws BusinessException;

    public boolean addAppSpecify(Long appId,Long skinId) throws BusinessException;

    public List<AppSimpleDto> findAppSpecifyList(Long skinId);

    public List<JSONObject> loadDevSkinList(Long appId) throws BusinessException;
    /**
     * 橱窗列表
     * @param appId
     * @return
     */
    List<FloorShowcaseContentDto> getShowcaseList(long appId)  throws Exception;

    void saveShowcaseConfig(ShowcaseDto showcaseDto) throws BusinessException;

    void delShowcaseConfig(Long appId,Integer place)throws BusinessException;

}
