package cn.com.duiba.developer.center.biz.bo;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.InternalLetterQueryEntity;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.base.Optional;

/**
 * Created by liuyao on 16/7/18.
 */
public interface InternalLetterBo {
    /**
     * 管理员提交表单
     * @param letter
     * @throws BusinessException
     */
    public void submitInternalLetter(Optional<InternalLetterDO> letter) throws BusinessException;

    /**
     * 管理员删除
     * @param letterId
     * @throws BusinessException
     */
    public void deleteInternalLette(Long letterId) throws BusinessException;

    /**
     * 开发者删除
     * @param developerId
     * @param letterId
     * @throws BusinessException
     */
    public void deleteInternalLette(Long developerId,Long letterId) throws BusinessException;

    /**
     * 管理员站内信分页列表
     * @param param
     * @return
     */
    public PaginationVO<InternalLetterDO> getInternalLetterPage(InternalLetterQueryEntity param);

    /**
     * 开发者站内信分页列表
     * @param param
     * @return
     */
    public PaginationVO<InternalLetterKeyDO> getInternalLetterKeyPage(InternalLetterQueryEntity param);

    /**
     * 开发者标记全部已读
     * @param developerId
     * @return
     */
    public int setAllReaded(Long developerId);

    /**
     * 开发者加载站内信详情
     * @param developerId
     * @param letterId
     * @return
     */
    public InternalLetterDO developerFindInternalLetter(Long developerId, Long letterId);

    /**
     * 管理员获取站内信详情
     * @param letterId
     * @return
     */
    public InternalLetterDO find(Long letterId);
    /**
     * 获取未读条数
     * @param developerId
     * @return
     */
    public Integer getNoRead(Long developerId);
}
