package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.entity.AppExtraEntity;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.event.DeveloperCreateEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.AppIdGenerator;
import cn.com.duiba.developer.center.common.tools.SecureTool;
import cn.com.duiba.developer.center.common.tools.SwitchTool;
import cn.com.duiba.service.exception.BusinessException;

import com.google.common.eventbus.Subscribe;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class AppBoImpl implements AppBo {
    private static final Logger log= LoggerFactory.getLogger(AppBoImpl.class);
    @Autowired
    private AppService appService;
    @Autowired
    private AppExtraService appExtraService;

    //private AppUrlS
    @Autowired
    private BizEventBus eventBus;

    @PostConstruct
    public void init(){
        eventBus.register(this);
    }

    @Override
    public Long createApp(CreateAppQueryParams params) throws BusinessException {
        //个数限制改为在web端自行判断
//        Integer appCount = appService.findAppCountByDevId(params.getDeveloperId());
//        if(appCount>10) throw new BusinessException("创建的应用不能超过10个");

        AppDO app=new AppDO(true);
        app.setName(params.getName());
        app.setCreditsRate(params.getCreditsRate());

        app.setAppKey(AppIdGenerator.generate());
        String appSecretCode = AppIdGenerator.generate();
        app.setAppSecretCode(SecureTool.encryptAppSecret(appSecretCode));

        app.setDeveloperId(params.getDeveloperId());
        app.setBudget(null);
        app.setBudgetRemain(null);
        app.setDayBudget(null);
        app.setDayBudgetRemain(null);
        app.setUnitName(params.getUnitName());

        List<String> categoryList = params.getCategory();
        app.setCategory1(categoryList.get(0));
        if(categoryList.size()==2){
            app.setCategory2(categoryList.get(1));
        }

        appService.insert(app);

        SwitchTool tool = SwitchTool.getSwitchTool(app.getId(),app.getAppSwitch());
        tool.setSwitchByBoundType(AppSimpleDto.SwitchCloseClientAlarm,true);
        tool.setSwitchByBoundType(AppSimpleDto.SwitchShowcasePlace1,true);
        tool.setSwitchByBoundType(AppSimpleDto.SwitchShowcasePlace2,true);
        tool.setSwitchByBoundType(AppSimpleDto.SwitchShowcasePlace3,true);

        //无积分模式
        if(params.getMallCredits()){
            tool.setSwitchByBoundType(AppSimpleDto.SwitchMallCreditsType,true);
            tool.setSwitchByBoundType(AppSimpleDto.SwitchCloseCreditsType,true);
            tool.setSwitchByBoundType(AppSimpleDto.SwitchCloseAppTradingLimit,true);
        }

        appService.updateSwitch(tool);

        AppCreateEvent event = new AppCreateEvent();
        event.setApp(app);
        event.setParams(params);
        eventBus.post(event);

        return app.getId();
    }

    @Subscribe
    public void createFristAppListener(DeveloperCreateEvent event){
        if(StringUtils.isBlank(event.getAppName())){
            return;
        }
        DeveloperEntity developer = event.getDeveloper();
        try {
            CreateAppQueryParams params = new CreateAppQueryParams();
            params.setDeveloperId(developer.getId());
            params.setName(event.getAppName());
            params.setCreditsRate(100);
            params.setUnitName("金币");
            params.setCategory("工具");
            createApp(params);
        }catch (BusinessException e){
            log.error("开发者:"+developer.getEmail()+"创建第一个App失败",e);
        }
    }

    /**
     * from AappManageCtrl.updateAppConfig in manager,
     * @param appId
     * @param entranceDesc
     * @param callLoginProgram
     * @param appType
     * @param useloginCode
     * @param freeItemVip
     */
    @Transactional(value = DsConstants.DATABASE_CREDITS)
    public void updateAppConfig(Long appId,String entranceDesc, String callLoginProgram,String appType, String useloginCode,String freeItemVip,String exchangeCreditsType){
        AppExtraEntity appExtraEntity = appExtraService.findByAppId(appId);
        if(null == appExtraEntity) {
            appExtraEntity = new AppExtraEntity();
            appExtraEntity.setAppId(appId);
            appExtraEntity.setEntranceDesc(entranceDesc);
            appExtraEntity.setCallLoginProgram(callLoginProgram);
            appExtraService.insertAppConfig(appExtraEntity);
        } else {
            appExtraService.updateAppConfig(appId, entranceDesc, callLoginProgram);
        }
        AppSimpleDto app = appService.getObject(appId);
        SwitchTool tool = SwitchTool.getSwitchTool(app.getId(),app.getAppSwitch());

        tool.setSwitchByBoundType(AppSimpleDto.SwitchCloseCreditsType,"on".equals(appType));
        tool.setSwitchByBoundType(AppSimpleDto.SwitchUseLoginCode,"on".equals(useloginCode));
        tool.setSwitchByBoundType(AppSimpleDto.SwitchFreeItemVip,"on".equals(freeItemVip));
        tool.setSwitchByBoundType(AppSimpleDto.SwitchExchangeCreditsType,"on".equals(exchangeCreditsType));

        appService.updateSwitch(tool);
    }

    @Override
    public AppSimpleDto getSimpleApp(Long id) {
        return appService.getObject(id);
    }



}
