package cn.com.duiba.developer.center.biz.bo.impl;

import java.util.Objects;

import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.AppUrlParams;
import cn.com.duiba.developer.center.biz.bo.AppManagerBo;
import cn.com.duiba.developer.center.biz.runnble.SendSecretEmailTask;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.support.ThreadPoolDuibaService;
import cn.com.duiba.developer.center.common.tools.SwitchTool;
import cn.com.duiba.service.exception.BusinessException;

/**
 * Created by liuyao on 16/8/11.
 */
@Service
public class AppManagerBoImpl implements AppManagerBo,ApplicationContextAware {
    private ApplicationContext ctx;
    @Autowired
    private AppService appService;
    @Autowired
    private DeveloperService developerService;
    @Autowired
    private AppBudgetService appBudgetService;
    @Autowired
    private ThreadPoolDuibaService threadPoolDuibaService;
    @Autowired
    private AppExtraService appExtraService;

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS)
    public void updateAppInfo(AppInfoFromParams params) throws BusinessException {
        AppSimpleDto app = appService.getObject(params.getAppId());
        if(Objects.equals(null,app)){
            throw new BusinessException("提交的AppId不存在");
        }

        AppSimpleDto app4u=new AppSimpleDto();
        app4u.setId(params.getAppId());
        app4u.setName(params.getAppName());
        app4u.setTitle(params.getAppTitle());
        app4u.setLogo(params.getLogo());
        app4u.setCreditsRate(params.getCreditsRate());
        app4u.setUnitName(params.getUnitName());
        app4u.setCategory1(params.getCategory1());
        app4u.setCategory2(params.getCategory2());
        app4u.setEarnCreditsUrl(params.getEarnCreditsUrl());
        appService.update(app4u);

        SwitchTool tool = SwitchTool.getSwitchTool(params.getAppId(),app.getAppSwitch());
        tool.setSwitchByBoundType(AppSimpleDto.SwitchCreditsDecimalPoint,params.getCreditsDecimalPoint());
        tool.setSwitchByBoundType(AppSimpleDto.SwitchCloseCreditsType,params.getCreditsType());
        appService.updateSwitch(tool);
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS)
    public void updateApiConfig(AppUrlParams appUrlParams) throws BusinessException {
        Long appId = appUrlParams.getId();
        AppSimpleDto app = appService.getObject(appId);
        if(Objects.equals(null,app)){
            throw new BusinessException("app不存在");
        }

        AppSimpleDto update = new AppSimpleDto();
        update.setId(appId);
        if(app.isAppSwitch(AppSimpleDto.SwitchMallCreditsType)){//简版
            String creditsRemainQueryUrl = StringUtils.trimToNull(appUrlParams.getCreditsRemainQueryUrl());
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String virtualUrl = StringUtils.trimToNull(appUrlParams.getVirtualExchangeUrl());
            update.setVirtualExchangeUrl(virtualUrl);
            if (update.getCreditsRemainQueryUrl() != null) {
                update.setEnable(true);
            }
        }else{
            String creditsRemainQueryUrl = StringUtils.trimToNull(appUrlParams.getCreditsRemainQueryUrl());
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String creditsConsumeNotifyUrl = StringUtils.trimToNull(appUrlParams.getCreditsConsumeNotifyUrl());
            update.setCreditsConsumeNotifyUrl(creditsConsumeNotifyUrl);
            String creditsConsumeRequestUrl = StringUtils.trimToNull(appUrlParams.getCreditsConsumeRequestUrl());
            update.setCreditsConsumeRequestUrl(creditsConsumeRequestUrl);
            String virtualUrl = StringUtils.trimToEmpty(appUrlParams.getVirtualExchangeUrl());
            update.setVirtualExchangeUrl(virtualUrl);
            update.checkApiEnableUpdate();

            //更新加积分接口
            String addCreditsUrl = StringUtils.trimToEmpty(appUrlParams.getAddCreditsUrl());
            appExtraService.updateAddCreditsUrl(app.getId(),addCreditsUrl);
        }

        appService.updateUrls(update);
    }

    @Override
    public void budgetConfig(AppBudgetDto appBudget) throws BusinessException {
        appBudgetService.updateForDeveloperBack(appBudget);
    }

    @Override
    public void doSendSecret(Long appId) throws BusinessException {
        AppSimpleDto app = appService.getObject(appId);
        if(Objects.equals(null,app)){
            throw new BusinessException("App不存在");
        }
        if(app.getSendSecret()){
            throw new BusinessException("此APP已经发送过密钥");
        }
        DeveloperEntity dev = developerService.find(app.getDeveloperId());
        SendSecretEmailTask task = ctx.getBean(SendSecretEmailTask.class);
        task.setApp(app);
        task.setDeveloper(dev);
        threadPoolDuibaService.submit(task,ThreadPoolDuibaService.PriorityHigh);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }
}
