package cn.com.duiba.developer.center.biz.bo.impl;

import java.util.*;

import cn.com.duiba.developer.center.api.domain.dto.*;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import cn.com.duiba.developer.center.biz.entity.ShowcaseEntity;
import cn.com.duiba.developer.center.biz.event.FloorSkinCodeSynEvent;
import cn.com.duiba.developer.center.biz.service.credits.floor.*;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.common.constants.ShowcaseConstants;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.*;
import com.google.common.eventbus.Subscribe;

import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.bo.FloorBo;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.service.exception.BusinessException;

import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;


/**
 * Created by liuyao on 16/8/16.
 * 业务楼层:可被前端直接编辑的楼层
 * 副本楼层:记录当前皮肤真实代码的备份楼层
 */
@Service
public class FloorBoImpl implements FloorBo {
    @Autowired
    private CreditsFloorCodeService creditsFloorCodeService;
    @Autowired
    private DeveloperService developerService;
    @Autowired
    private CreditsFloorSkinService creditsFloorSkinService;
    @Autowired
    private CreditsFloorCodeCopyService creditsFloorCodeCopyService;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private AppLayoutService appLayoutService;
    @Autowired
    private CreditsFloorSkinSpecifyService creditsFloorSkinSpecifyService;
    @Autowired
    private AppService appService;
    @Autowired
    private AppLayoutBrickService appLayoutBrickService;
    @Autowired
	CreditsFloorShowcaseService creditsFloorShowcaseService;
    
    
    Logger log = Logger.getLogger(FloorBoImpl.class);
    
    @PostConstruct
    public void init(){
        eventBus.register(this);
    }
    
    @Override
    public PaginationVO<JSONObject> getFloorPage(FloorPageParams params) throws BusinessException {
        if(null == params.getFloorType()){
            throw new BusinessException("检索楼层必须指定楼层类型");
        }
        PaginationVO<CreditsFloorCodeDto> page = creditsFloorCodeService.selectFloorCodesByType(params);
        List<CreditsFloorCodeDto> list= page.getRows();

        List<JSONObject> jlist = Lists.newArrayList();
        //{id:2,name:"banner楼层",modified:1470905947012,image:"//yun.dui88.com/images/201607/2sp7tpq0gc.png"}
        for(CreditsFloorCodeDto t:list){
            JSONObject json = new JSONObject();
            json.put("id",t.getId());
            json.put("name",t.getFloorName());
            json.put("modified",t.getGmtModified().getTime());
            json.put("image",t.getImage());
            jlist.add(json);
        }
        PaginationVO<JSONObject> jsonpage = new PaginationVO<JSONObject>();
        jsonpage.setRows(jlist);
        jsonpage.setTotalCount(page.getTotalCount());

        return jsonpage;
    }

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS)
    public CreditsFloorSkinDto insertFloorSkin(Optional<CreditsFloorSkinDto> dtoOpt) throws BusinessException {
        CreditsFloorSkinDto dto = dtoOpt.get();
        ValidatorTool.valid(dto);

        String floors = dto.getSkinList();//{id:楼层Id,name:楼层名称,md5:真实MD5,syn:是否更新}
        JSONArray jsonArray = JSONArray.parseArray(floors);
        jsonArray = verifFloorsJson(jsonArray);
        dto.setSkinList(jsonArray.toJSONString());
        dto= creditsFloorSkinService.insertFloorSkin(dto);

        //发布皮肤更新事件
        FloorSkinCodeSynEvent event = new FloorSkinCodeSynEvent();
        event.setFloorsJsonArray(floors);
        event.setSkinId(dto.getId());
        eventBus.post(event);

        return dto;
    }

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS)
    public int updateFloorSkin(Optional<CreditsFloorSkinDto> dtoOpt) throws BusinessException {
        CreditsFloorSkinDto dto = dtoOpt.get();
        ValidatorTool.valid(dto);
        CreditsFloorSkinDto skin = creditsFloorSkinService.selectFloorSkinForUpdate(dto.getId());
        if(skin==null) throw new RuntimeException("更新的皮肤不存在");
        String floors = dto.getSkinList();//{id:楼层Id,name:楼层名称,md5:业务楼层MD5,syn:是否更新}

        JSONArray jsonArray = JSONArray.parseArray(floors);
        jsonArray = verifFloorsJson(jsonArray);
        dto.setSkinList(jsonArray.toJSONString());

        int ret = creditsFloorSkinService.updateFloorSkin(dto);
        if(ret>0){
            //发布皮肤更新事件
            FloorSkinCodeSynEvent event = new FloorSkinCodeSynEvent();
            event.setSkinId(dto.getId());
            event.setFloorsJsonArray(floors);
            eventBus.post(event);
        }
        return ret;
    }

    /**
     * {
     *  id:1,
     *  name:'第一个皮肤',
     *  floorList:[
     *      {id:1,name:'默认banner',needSyn:false},
     *      {id:1,name:'游戏子页面',needSyn:false},
     *      {id:1,name:'图表区',needSyn:true},
     *  ],
     *  specify:true
     *  open:true
     *}
     * @param params
     * @return
     */
    @Override
    public PaginationVO<JSONObject> getSkinPage(FloorPageParams params) {
        PaginationVO<CreditsFloorSkinDto> page=creditsFloorSkinService.selectFloorSkins(params);
        List<CreditsFloorSkinDto> list = page.getRows();

        PaginationVO<JSONObject> jsonPage = new PaginationVO<JSONObject>();
        jsonPage.setTotalCount(page.getTotalCount());

        if(!list.isEmpty()){
            Map<Long,String> table = Maps.newHashMap();
            Set<Long> floorIdSet =Sets.newHashSet();
            for (CreditsFloorSkinDto it:list){
                JSONArray array = JSONArray.parseArray(it.getSkinList());
                for(int i = 0;i<array.size();i++){
                    JSONObject floor = array.getJSONObject(i);
                    Long floorId = floor.getLong("id");
                    floorIdSet.add(floorId);
                }
            }
            List<CreditsFloorCodeDto> floorCodes = creditsFloorCodeService.selectFloorCodeList(floorIdSet);
            for(CreditsFloorCodeDto floor : floorCodes){
                table.put(floor.getId(),floor.getMd5());
            }

            List<JSONObject> skinJsonList = Lists.newArrayList();
            for(CreditsFloorSkinDto it:list){
                JSONObject skin = new JSONObject();
                skin.put("id",it.getId());
                skin.put("name",it.getSkinName());
                skin.put("specify",it.getSpecify());
                skin.put("status",it.getStatus());
                JSONArray array = JSONArray.parseArray(it.getSkinList());
                JSONArray jsonArray = new JSONArray();
                for(int i = 0;i<array.size();i++){
                    JSONObject floor = array.getJSONObject(i);
                    Long floorId = floor.getLong("id");
                    String md5 = floor.getString("md5");
                    String floorMd5 = table.get(floorId);
                    floor.put("needSyn",!Objects.equal(md5,floorMd5));
                    jsonArray.add(floor);
                }
                skin.put("floorList",jsonArray);
                skinJsonList.add(skin);
            }
            jsonPage.setRows(skinJsonList);
        }
        return jsonPage;
    }

    /**
     * id
     * name
     * floors:{id:2,name:"icon楼层",type:2,needSyn:true,pageId:子页面Id}
     * @param id
     * @return
     */
    @Override
    public JSONObject getOneSkinConfig(Long id) throws BusinessException {
        CreditsFloorSkinDto skin = creditsFloorSkinService.selectFloorSkinById(id);
        if(Objects.equal(null,skin)){
            throw new BusinessException("无此皮肤");
        }
        JSONObject skinJson = new JSONObject();
        skinJson.put("id",skin.getId());
        skinJson.put("name",skin.getSkinName());
        skinJson.put("image",skin.getSkinImage());
        Set<Long> floorIds = Sets.newHashSet();
        JSONArray array = JSONArray.parseArray(skin.getSkinList());
        for(int i=0;i<array.size();i++){
            JSONObject json = array.getJSONObject(i);
            Long floorId = json.getLong("id");
            floorIds.add(floorId);
        }

        List<CreditsFloorCodeDto> floorList = creditsFloorCodeService.selectFloorCodeList(floorIds);
        Map<Long,String> floorMd5Map = Maps.newHashMap();
        for (CreditsFloorCodeDto it:floorList){
            floorMd5Map.put(it.getId(),it.getMd5());
        }

        JSONArray jsonArray = new JSONArray();
        for(int i=0;i<array.size();i++){
            JSONObject json = array.getJSONObject(i);
            Long floorId = json.getLong("id");
            json.put("needSyn",!Objects.equal(json.getString("md5"),floorMd5Map.get(floorId)));
            jsonArray.add(json);
        }
        skinJson.put("floors",jsonArray);
        return skinJson;
    }

    @Override
    public boolean switchSkinSpecify(Long id, Boolean isOpen) throws BusinessException {
        CreditsFloorSkinDto skin = creditsFloorSkinService.selectFloorSkinById(id);
        if(skin==null) throw new BusinessException("Id无效");
        if(isOpen==null) throw new BusinessException("缺失参数");
        if(isOpen.equals(skin.getSpecify())){
            return isOpen;
        }

        if(isOpen){
            int count = appLayoutService.useSkinCount(id);
            if(count!=0) throw new BusinessException("该皮肤已经有App使用,无法再开启定向");
            creditsFloorSkinService.switchSkinSpecify(id,true);
            return true;
        }else{//如果关闭,则检查是否对App开启了定向
            int count = creditsFloorSkinSpecifyService.findSkinOpenSpecifyCount(id);
            if(count!=0) throw new BusinessException("该皮肤已经有App参与定向,无法再关闭定向开关");
            creditsFloorSkinService.switchSkinSpecify(id,false);
            return false;
        }
    }

    @Override
    public boolean addAppSpecify(Long appId, Long skinId) throws BusinessException {
        CreditsFloorSkinDto skin = creditsFloorSkinService.selectFloorSkinById(skinId);
        if(!skin.getSpecify()) throw new BusinessException("该皮肤定向开关还未打开,无法添加定向");
        int ret = creditsFloorSkinSpecifyService.addAppSpecify(appId,skinId);
        return ret==1;
    }

    @Override
    public void saveShowcaseConfig(ShowcaseDto showcaseDto) throws BusinessException {
        ShowcaseEntity entity=new ShowcaseEntity();
        BeanUtils.copyProperties(showcaseDto,entity);
        entity.setStatus(ShowcaseConstants.STATUS_OPEN);
        if(creditsFloorShowcaseService.getShowcaseContentIgnoreStatus(showcaseDto.getAppId(),showcaseDto.getPlace())!=null){
            creditsFloorShowcaseService.updateShowcaseConfig(entity);
        }else {
            creditsFloorShowcaseService.saveShowcaseConfig(entity);
        }
    }

    @Override
    public void delShowcaseConfig(Long appId, Integer place) throws BusinessException {
        creditsFloorShowcaseService.delShowcaseConfig(appId,place);
    }

    @Override
    public List<AppSimpleDto> findAppSpecifyList(Long skinId) {
        CreditsFloorSkinDto skin = creditsFloorSkinService.selectFloorSkinById(skinId);
        if(!skin.getSpecify()) return Collections.emptyList();//没开启定向,肯定没有定向列表
        List<Long> appIds = creditsFloorSkinSpecifyService.selectSpecifyAppIdsBySkinId(skinId);
        List<AppSimpleDto> appList = appService.findByAppIds(appIds);

        return appList;
    }

    private Ordering<JSONObject> ordering = Ordering.natural().reverse().onResultOf(new Function<JSONObject,Long>(){
        @Override
        public Long apply(JSONObject skin) {
            if(skin.getShort("floorType") == AppLayoutDto.Skin_Type_Old_Theme){
                return Long.MIN_VALUE;
            }else{
                return skin.getLong("id");
            }
        }
    });
    @Override
    public List<JSONObject> loadDevSkinList(Long appId) throws BusinessException {
        AppLayoutDto appLayout = appLayoutService.buildAppLayoutByAppId(appId);
        if(appLayout==null){
            throw new BusinessException("appId is Invalid");
        }
        List<Long> skinIds = creditsFloorSkinSpecifyService.selectSkinIdBySpecifyAppId(appId);
        List<CreditsFloorSkinDto> skinList = creditsFloorSkinService.findDevSkinList(skinIds);

        List<JSONObject> array = Lists.newArrayList();
        Set<Long> idSet = Sets.newHashSet();
        for(CreditsFloorSkinDto skin : skinList){
            JSONObject json = new JSONObject();
            json.put("id",skin.getId());
            json.put("floorType",AppLayoutDto.Skin_Type_Floor_Skin);
            json.put("name",skin.getSkinName());
            json.put("image",skin.getSkinImage());
            if(Objects.equal(AppLayoutDto.Skin_Type_Floor_Skin,appLayout.getSkinType()) && Objects.equal(skin.getId(),appLayout.getSkinId())){
                json.put("selected",true);
            }else{
                json.put("selected",false);
            }
            array.add(json);
            idSet.add(skin.getId());
        }
        //找出当前被使用缺被隐藏皮肤
        if (appLayout.getSkinType() == AppLayoutDto.Skin_Type_Floor_Skin && !idSet.contains(appLayout.getSkinId())){
            CreditsFloorSkinDto skin = creditsFloorSkinService.selectFloorSkinById(appLayout.getSkinId());
            JSONObject json = new JSONObject();
            json.put("id",skin.getId());
            json.put("floorType",AppLayoutDto.Skin_Type_Floor_Skin);
            json.put("name",skin.getSkinName());
            json.put("image",skin.getSkinImage());
            json.put("selected",true);
            array.add(json);
        }else if(appLayout.getSkinType() == AppLayoutDto.Skin_Type_Old_Theme){//如果开发者使用老皮肤,则把当前使用的皮肤放在最后面
            AppLayoutBrickDO brick =  appLayoutBrickService.findCacheAppLayoutBrick(appLayout.getBrickId());
            JSONObject json = new JSONObject();
            json.put("id",brick.getId());
            json.put("floorType",AppLayoutDto.Skin_Type_Old_Theme);
            json.put("name",brick.getName());
            json.put("image",brick.getImage());
            json.put("selected",true);
            array.add(json);
        }
        array = ordering.sortedCopy(array);
        return array;
    }


    /**
     * 去除无用字段,同时业务验证
     * @param jsonArray
     * @return
     */
    private JSONArray verifFloorsJson(JSONArray jsonArray) throws BusinessException {
        JSONArray newJson = new JSONArray();
        if(jsonArray==null) throw new RuntimeException("楼层配置异常");
        for(int i=0;i<jsonArray.size();i++){
            JSONObject json = jsonArray.getJSONObject(i);
            if(!json.containsKey("id")) throw new BusinessException("楼层Id缺失");
            if(!json.containsKey("name")) throw new BusinessException("楼层名称缺失");
            if(!json.containsKey("md5")) throw new BusinessException("楼层md5码缺失");
            if(!json.containsKey("type")) throw new BusinessException("楼层类型缺失");
            if(Objects.equal(json.getShort("type"), CreditsFloorCodeDto.CREDITS_FLOOR_TYPE_PAGE) && !json.containsKey("pageId")){
                throw new BusinessException("子页面类型的楼层必须指定具体子页面Id");
            }
            JSONObject floor = new JSONObject();
            floor.put("id",json.get("id"));
            floor.put("name",json.get("name"));
            floor.put("md5",json.get("md5"));
            floor.put("type",json.get("type"));
            if(json.containsKey("pageId")) floor.put("pageId",json.get("pageId"));
            newJson.add(floor);
        }
        return newJson;
    }

    /**
     * 检测同步,更新皮肤副本
     * @param event
     * @throws BusinessException
     */
    @Subscribe
    @Transactional(DsConstants.DATABASE_CREDITS)
    public void SynCopyCode(FloorSkinCodeSynEvent event) throws BusinessException {
        ValidatorTool.valid(event);

        Map<Long,Boolean> synSyn = event.getSynMap();
        Long skinId = event.getSkinId();

        Map<Long,CreditsFloorCodeCopyDto> copyMap = Maps.newHashMap();
        final Set<Long> copyIds = copyMap.keySet();
        List<CreditsFloorCodeCopyDto> copyDtoList = creditsFloorCodeCopyService.seletListBySkinId(skinId);
        for(CreditsFloorCodeCopyDto it:copyDtoList){
            copyMap.put(it.getFloorId(),it);
        }
        final Set<Long> floorIdSet = synSyn.keySet();
        Map<Long,CreditsFloorCodeDto> floorMap = Maps.newHashMap();
        List<CreditsFloorCodeDto> floorlist = creditsFloorCodeService.selectFloorCodeList(floorIdSet);
        for(CreditsFloorCodeDto it : floorlist){
            floorMap.put(it.getId(),it);
        }

        //1.要增加的,在新配置中存在,在备份中不存在
        final Set<Long> addSet = Sets.filter(floorIdSet, new Predicate<Long>() {
            @Override
            public boolean apply(Long input) {
                return !copyIds.contains(input);
            }
        });
        if(!addSet.isEmpty()){
            List<CreditsFloorCodeCopyDto> insertList = Lists.newArrayList();
            for(Long floorId : addSet){
                CreditsFloorCodeDto code = floorMap.get(floorId);
                CreditsFloorCodeCopyDto insert = new CreditsFloorCodeCopyDto();
                insert.setFloorId(floorId);
                insert.setMd5(code.getMd5());
                insert.setSkinId(skinId);
                insert.setSourceUrl(code.getSourceUrl());
                insertList.add(insert);
            }
            creditsFloorCodeCopyService.insertFloorCodeCopyList(insertList);
        }


        //2.要删除的,在副本里面有,在新配置里面没有
        Set<Long> delSet = Sets.filter(copyIds, new Predicate<Long>() {
            @Override
            public boolean apply(Long input) {
                return !floorIdSet.contains(input);
            }
        });
        if(!delSet.isEmpty()){
            creditsFloorCodeCopyService.deleteFloorCodeCopyList(skinId,delSet);
        }


        //3.要同步的
        Set<Long> updateSet = Sets.filter(floorIdSet, new Predicate<Long>() {
            @Override
            public boolean apply(Long input) {
                return !addSet.contains(input);
            }
        });
        if(!updateSet.isEmpty()){
            for(Long floorId:updateSet){
                if(!synSyn.get(floorId)) continue;
                CreditsFloorCodeDto floor = floorMap.get(floorId);
                CreditsFloorCodeCopyDto copy = copyMap.get(floorId);
                if(Objects.equal(floor.getMd5(),copy.getMd5())) continue;

                CreditsFloorCodeCopyDto update = new CreditsFloorCodeCopyDto();
                update.setId(copy.getId());
                update.setMd5(floor.getMd5());
                update.setSourceUrl(floor.getSourceUrl());
                creditsFloorCodeCopyService.updateFloorCodeCopy(update);
            }
        }
    }

	@Override
	public List<FloorShowcaseContentDto> getShowcaseList(long appId)  throws Exception{
 		return creditsFloorShowcaseService.getShowcaseList(appId);
	}

}
