package cn.com.duiba.developer.center.biz.dao;

import cn.com.duiba.developer.center.api.domain.BaseDO;
import cn.com.duiba.developer.center.biz.entity.BaseEntity;
import cn.com.duiba.developer.center.biz.entity.KeyValueEntity;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Table;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by liuyao on 2016/11/4.
 */
public interface KeyValueDao{
    /**
     * 获取键值对应的扩展类型
     * @return
     */
    Class<? extends BaseEntity> getEntityType();

    /**
     * 查询bizId下对应的所有PropName
     * @param bizId
     * @return
     */
    List<String> findAllPropNames(Long bizId);

    /**
     * 获取一个扩展对象的一个键值
     * @param bizId
     * @param propName
     * @return
     */
    KeyValueEntity findOneEntry(Long bizId,String propName);

    /**
     * 获取一个扩展对象的几个键值
     * @param bizId
     * @param propNameSet
     * @return
     */
    List<KeyValueEntity> findEntrys(Long bizId,List<String> propNameSet);

    /**
     * 获取多个对象的多个键值
     * 这之所以返回Multimap的实例类,是因为ArrayListMultimap的键特性是HashMap查询效率高
     * 而值的特性是ArrayList迭代效率高 恰好满足该方法的业务场景,也是强制让实现实例使用ArrayListMultimap
     * @param bizIds
     * @param propNameSet
     * @return
     */
    ArrayListMultimap<Long,KeyValueEntity> findMultiEntrys(List<Long> bizIds, List<String> propNameSet);

    /**
     * 删除一个拓展类的所有字段(只是置为null)
     * @param bizId
     * @return
     */
    int deleteAllEntrys(Long bizId);

    /**
     * 指定删除一个拓展类的几个字段(只是置为null)
     * @param bizId
     * @param propNameSet
     * @return
     */
    int deleteEntrys(Long bizId,List<String> propNameSet);

    /**
     * 更新单个键值
     * @param bizId
     * @param propName
     * @param value
     * @return
     */
    int updateOneEntry(Long bizId,String propName,String value);

    /**
     * 更新一个拓展类下的几个键值
     * @param entrys
     * @return
     */
    int updateEntrys(Long bizId,List<KeyValueEntity> entrys);

    /**
     * 向数据库中新增属性
     * @param entrys
     * @return
     */
    int insertEntrys(List<KeyValueEntity> entrys);
}
