/**
 * Project Name:developer-center-biz File Name:AppBannerDao.java Package Name:cn.com.duiba.developer.center.biz.dao.app
 * Date:2016年8月10日下午7:21:02 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.dao.app;

import java.util.List;

import cn.com.duiba.developer.center.biz.entity.AppBannerEntity;

/**
 * ClassName:AppBannerDao <br/>
 * Date: 2016年8月10日 下午7:21:02 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public interface AppBannerDao {

    public AppBannerEntity find(Long id);

    /**
     * 
     * 根据主键和appId更新appBanner
     * 所有的写操作都需要带上appId，防止未授权操作
     */
    public Integer updateByIdAndAppId(AppBannerEntity appBanner);

    public void insert(AppBannerEntity appBanner);

    public Integer findMaxPlayload(Long appId, String type);

    public List<AppBannerEntity> findAllByAppId(Long appId, Boolean deleted);

    public List<AppBannerEntity> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted);

    /**
     * findListBetweenPayload:查询指定区间内的banner列表. <br/>
     * 查询区间为闭区间[startPayload, endPayload]
     * 
     * @author zhanglihui
     * @param appId app编号
     * @param type 类型 banner/button
     * @param startPayload 查询起始payload值
     * @param endPayload 查询结束payload值
     * @return
     * @since JDK 1.6
     */
    public List<AppBannerEntity> findListBetweenPayload(Long appId, String type, Integer startPayload,
                                                        Integer endPayload);

    /**
     * 
     * 根据appItemId查询banner列表（包含已删除的）
     *
     * @author zhanglihui
     * @param appId     app编号
     * @param appItemId 开发者商品id
     * @param type      类型 {@link cn.com.duiba.developer.center.api.domain.enums.BannerOrButtonEnum}
     * @return
     * @since JDK 1.6
     */
    public List<AppBannerEntity> findBannerByItemId(Long appId, Long appItemId, String type);
}
