package cn.com.duiba.developer.center.biz.dao.app.impl;

import cn.com.duiba.developer.center.biz.entity.AppExtraEntity;
import cn.com.duiba.developer.center.biz.dao.app.AppExtraDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/18.
 */
@Repository
public class AppExtraDaoImpl extends BaseDao implements AppExtraDao {

    @Override
    public AppExtraEntity findByAppId(Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        return selectOne("findByAppId", map);
    }

    @Override
    public void insert(AppExtraEntity appExtraEntity) {
        insert("insert", appExtraEntity);
    }

    @Override
    public AppExtraEntity find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public Integer update(AppExtraEntity appExtraEntity) {
        return update("update", appExtraEntity);
    }

    @Override
    public String findCallLoginProgramByAppId(Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        return selectOne("findCallLoginProgramByAppId", map);
    }

    @Override
    public Integer updateAppConfig(Long appId, String entranceDesc,
                                   String callLoginProgram) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        map.put("entranceDesc", entranceDesc);
        map.put("callLoginProgram", callLoginProgram);
        return update("updateAppConfig", map);
    }

    @Override
    public void insertAppConfig(AppExtraEntity appExtraEntity) {
        insert("insertAppConfig", appExtraEntity);
    }

    @Override
    public List<AppExtraEntity> findByAppIds(List<Long> appIds) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appIds", appIds);
        return selectList("findByAppIds",map);
    }

    @Override
    public int updateAppPerson(Long appId, String appPerson) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId", appId);
        map.put("appPerson", appPerson);
        return update("updateAppPerson", map);
    }

    @Override
    public List<Long> findByAppPerson(String name) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("name", name);
        return selectList("findByAppPerson",map);
    }

    @Override
    public int updateAddCreditsUrl(Long appId,String addCreditsUrl){
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId",appId);
        map.put("addCreditsUrl",addCreditsUrl);
        return update("updateAddCreditsUrl",map);
    }
}
