package cn.com.duiba.developer.center.biz.dao.app.impl;

import cn.com.duiba.developer.center.biz.dao.KeyValueDao;
import cn.com.duiba.developer.center.biz.entity.AppNewExtraEntity;
import cn.com.duiba.developer.center.biz.entity.BaseEntity;
import cn.com.duiba.developer.center.biz.entity.KeyValueEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 2016/11/4.
 * app新拓展表的底层键值DAO
 */
@Repository
public class AppNewEntityDaoImpl extends BaseDao implements KeyValueDao {

    @Override
    public Class<? extends BaseEntity> getEntityType() {
        return AppNewExtraEntity.class;
    }

    @Override
    public List<String> findAllPropNames(Long bizId){
        return selectList("findAllPropNames",bizId);
    }

    @Override
    public KeyValueEntity findOneEntry(Long bizId, String propName) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId",bizId);
        params.put("propName",propName);
        return selectOne("findOneEntry",params);
    }

    @Override
    public List<KeyValueEntity> findEntrys(Long bizId, List<String> propNames) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId",bizId);
        params.put("propNames",propNames);
        return selectList("findEntrys",params);
    }

    @Override
    public ArrayListMultimap<Long,KeyValueEntity> findMultiEntrys(List<Long> bizIds, List<String> propNames) {
        ArrayListMultimap<Long,KeyValueEntity> map = ArrayListMultimap.create();
        if(bizIds.isEmpty()||propNames.isEmpty()){
            return map;
        }
        Map<String,Object> params = Maps.newHashMap();
        params.put("appIds",bizIds);
        params.put("propNames",propNames);
        List<KeyValueEntity> list = selectList("findMultiEntrys",params);
        for(KeyValueEntity entity:list){
            map.put(entity.getBizId(),entity);
        }
        return map;
    }

    @Override
    public int deleteAllEntrys(Long bizId) {
        return update("deleteAllEntrys",bizId);
    }

    @Override
    public int deleteEntrys(Long bizId, List<String> propNames) {
        if(propNames.isEmpty()){
            return 0;
        }
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId",bizId);
        params.put("propNames",propNames);
        return update("deleteEntrys",params);
    }

    @Override
    public int updateOneEntry(Long bizId, String propName, String value) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId",bizId);
        params.put("propName",propName);
        params.put("value",value);
        return update("updateOneEntry",params);
    }

    @Override
    public int updateEntrys(Long bizId, List<KeyValueEntity> entrys) {
        if(entrys.isEmpty()){
            return 0;
        }
        Map<String,Object> params = Maps.newHashMap();
        params.put("appId",bizId);
        params.put("entrys",entrys);
        return update("updateEntrys",params);
    }


    @Override
    public int insertEntrys(List<KeyValueEntity> entrys){
        if(entrys.isEmpty()){
            return 0;
        }
        Map<String,Object> params = Maps.newHashMap();
        params.put("entrys",entrys);
        return insert("insertEntrys",params);
    }
}
