/**
 * Project Name:developer-center-biz File Name:TagsDaoImpl.java Package
 * Name:cn.com.duiba.developer.center.biz.dao.app.impl Date:2016年8月16日上午10:12:43 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.dao.app.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.developer.center.biz.dao.app.TagsDao;
import cn.com.duiba.developer.center.biz.entity.TagEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

/**
 * ClassName:TagsDaoImpl <br/>
 * Date: 2016年8月16日 上午10:12:43 <br/>
 * 
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository
public class TagsDaoImpl extends BaseDao implements TagsDao {

    @Override
    public List<TagEntity> findAll() {
        return selectList("findAll");
    }

    @Override
    public TagEntity findByName(String tagsName) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("tagsName", tagsName);
        return selectOne("findByName", map);
    }

    @Override
    public void delete(Long id) {
        delete("delete", id);
    }

    @Override
    public void insert(TagEntity tagEntity) {
        insert("insert", tagEntity);
    }

    @Override
    public void update(TagEntity tagEntity) {
        update("update", tagEntity);
    }

    @Override
    public TagEntity find(Long id) {
        return selectOne("find", id);
    }
}
