package cn.com.duiba.developer.center.biz.dao.applayout;

import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import com.google.common.base.Optional;

import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/27.
 */
public interface AppLayoutBrickDao {

    /**
     * 获取所有的系统模板和模板总数
     * @param
     * @return
     */
    public List<AppLayoutBrickDO> getAllSystemLayoutBrickList(PageQueryEntity params);

    public Integer getSystemThemeLayoutPageCount(PageQueryEntity params);

    /**
     * 获取所有的定制模板和模板总数
     * @param params
     * @return
     */
    public List<AppLayoutBrickDO> getCustomThemeLayoutList(PageQueryEntity params);

    public Integer getCustomThemeLayoutCount(PageQueryEntity params);



    /**
     * @param id
     * @author 刘瑶
     */
    public AppLayoutBrickDO findWithSimple(Long id);
    /**
     * 新建一个模版片段
     * @param appLayoutBrick
     * @author 刘瑶
     */
    public int insert(AppLayoutBrickDO appLayoutBrick);
    /**
     * 找出所有的系统模版，不含content字段
     * @author 刘瑶
     */
    public List<AppLayoutBrickDO> findAllShowSystemBrickWithSimple();
    /**
     * 找出该AppId找出所有的定制主题
     * @param appId
     * @author 刘瑶
     */
    public List<AppLayoutBrickDO> findDingzhiThemeWithSimple(Long appId);
    /**
     * 获取皮肤代码
     * @param brickId
     * @return
     */
    public String getBrickContentById(Long brickId);

    /**
     * 更新模块的权重
     * @param brickId
     * @param payload
     * @return
     */
    public int updateLayoutBrickPayload(Optional<Long> id, Optional<Integer> payload);
    /**
     * 更新模块的状态(是否能够被开发者看到)
     * @param brickId
     * @param state
     * @return
     */
    public int updateLayoutBrickShowStatus(Optional<Long> id,Optional<Integer> status);
    /**
     *
     * @param brick
     * @return
     */
    public int updateBrick(AppLayoutBrickDO brick);
    /**
     * 逻辑删除一个模块(给管理员使用)
     * @param brickId
     * @param deleted
     * @return
     */
    public int updateBrickDelete(Optional<Long> id);


}
