package cn.com.duiba.developer.center.biz.dao.applayout;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.biz.entity.AppLayoutEntity;

import java.util.Collection;

/**
 * Created by liuyao on 16/7/29.
 */
public interface AppLayoutDao {
    /**
     * 新建布局
     * @param appLayout
     * @author 刘瑶
     */
    public int insert(AppLayoutEntity appLayout);
    /**
     * 根据AppId找出对应的布局
     * @param appId
     * @author 刘瑶
     */
    public AppLayoutEntity findByAppId(Long appId);
    /**
     * 更改主题色
     * @param color
     * @return
     */
    public int updateColor(Long id, String color);

    /**
     * 更新楼层皮肤,此操作会将skinType永久变为1
     * @param appId
     * @param skinId
     * @return
     */
    public int updateSkinId(Long appId,Long skinId);

    /**
     * 更新楼层排序和禁用配置
     * @param appId
     * @param json [{楼层配置},{楼层配置}]
     * @return
     */
    public int  updateDevelopSortJsonByAppId(Long appId,String json);

    /**
     * 更新楼层内容配置
     * @param appId
     * @param json {楼层Id:{配置1:value,配置2:value},楼层Id:{配置1:value,配置2:value}}
     * @return
     */
    public int  updateDevelopDataShowJsonByAppId(Long appId,String json);

    /**
     * 查询某个楼层皮肤使用的数量
     * @param skinId
     * @return
     */
    public Integer useSkinCount(Long skinId);

    /**
     * 选择楼层时,初始化楼层配置
     * @param appId
     * @param floorSortJson
     * @param floorConfigJson
     * @return
     */
    public int initFloorConfig(Long appId,String floorSortJson,String floorConfigJson);

    /**
     * 查询所有使用某个楼层皮肤的AppId
     * @param skinId
     * @return
     */
    public Collection<Long> useSkinAppIds(Long skinId);
}
