package cn.com.duiba.developer.center.biz.dao.center_config;

import cn.com.duiba.developer.center.api.domain.dto.AerosolGroupDto;
import cn.com.duiba.developer.center.biz.dao.center_config.AerosolGroupDao;
import cn.com.duiba.developer.center.biz.entity.AerosolGroupEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yaocheng on 2016/9/22.
 */
@Repository
public class AerosolGroupDao extends BaseDao{

    public Long insert(AerosolGroupEntity entity) {
        insert("insert",entity);
        return entity.getId();
    }

    public int delete(Long id) {
        return delete("delete", id);
    }

    public AerosolGroupEntity findGroupById(Long id) {
       return selectOne("findGroupById",id);
    }

    public List<AerosolGroupEntity> findAerosolGroupList() {
        return selectList("findAerosolGroupList");
    }

    public List<Long> findGroupIdByGroupNameLike(String groupName) {
        return selectList("findGroupIdByGroupNameLike",groupName);
    }

    public void updateAerosolGroupShowStatus(Long id, Boolean isShow) {
        Map<String,Object> params= Maps.newHashMap();
        params.put("id",id);
        params.put("isShow",isShow);
        update("updateAerosolGroupShowStatus",params);
    }

	public int updateAerosolGroup(AerosolGroupDto aerosolGroupDto) {
	     return update("updateAerosolGroup",aerosolGroupDto);
	}

}
