/**
 * duiba-developer AmbDeveloperWithdrawCashAuditDAO.java
 * 
 * File Created at 2015年12月24日 下午8:02:43
 * $Id$
 *
 * Copyright 2015 duiba.com Croporation Limited.
 * All rights reserved.
 */
package cn.com.duiba.developer.center.biz.dao.developer;

import cn.com.duiba.developer.center.biz.entity.AmbDeveloperWithdrawCashAuditEntity;

import java.util.List;


/**
 *
 * @create 2015年12月24日 下午8:02:43
 * @author Hermit
 * @version
 */
public interface AmbDeveloperWithdrawCashAuditDao {
    /**
     * 新增审核信息
     * @param ambDeveloperWithdrawCashAuditEntity
     */
    public void insert(AmbDeveloperWithdrawCashAuditEntity ambDeveloperWithdrawCashAuditEntity);
    
    /**
     * 根据ID查询
     * @param id
     * @return
     */
    public AmbDeveloperWithdrawCashAuditEntity findById(Long id);
    
    /**
     * 获取有效的审核通过的审核信息
     * @param developerId 
     * @param cashType 提现类型
     * @return
     */
    public AmbDeveloperWithdrawCashAuditEntity findValidPassAudit(Long developerId, String cashType);
    
    /**
     * 获取正在审核的信息
     * @param developerId
     * @return
     */
    public AmbDeveloperWithdrawCashAuditEntity findAuditing(Long developerId, String cashType);
    
    /**
     * 禁用所有效的审核
     * @param developerId
     * @param cashType
     */
    public void disableValidPassAudit(Long developerId, String cashType);
    
    /**
     * 将审核材料的状态由创建更新为待审核
     * @param auditId
     * @return
     */
    public int updateStatusCreateToWait(Long auditId);

    /**
     * @param auditIds
     */
    public List<AmbDeveloperWithdrawCashAuditEntity> findByIds(List<Long> auditIds); 
    
}
