package cn.com.duiba.developer.center.biz.dao.developer;

import java.util.Date;
import java.util.List;

import cn.com.duiba.developer.center.api.domain.paramquery.ADeveloperQueryEntity;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;

/**
 * Created by liuyao on 16/7/15.
 */
public interface DeveloperDao {

    DeveloperEntity findByEmail(String email);

    DeveloperEntity find(Long id);


    /**
     * 根据email模糊查询
     */
    List<DeveloperEntity> findByEmailLike(String email);

    List<DeveloperEntity> findAllByIdList(List<Long> idList);

    /**
     * 管理员后台开发者分页
     */
    List<DeveloperEntity> findDeveloperPage(ADeveloperQueryEntity queryEntity);

    /**
     * 管理员后台开发者列表总数
     */
    Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity);


    void insert(DeveloperEntity developerDO);


    int updateDeveloperSwitch(Long id, Integer developerSwitch);

    int updateLastRemindTime(Long id, Date lastRemindTime);

    int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company);

    int updatePassword(Long id, String password);

    int updateVerifyAndEnable(Long id, boolean verify, boolean enable);

    int updateJson(Long id,String jsonStr);

    List<Long> findAllEnbleId();
}
