/**
 * duiba-developer AmbDeveloperWithdrawCashAuditDAOImpl.java File Created at 2015年12月24日 下午8:11:13 $Id$ Copyright 2015
 * duiba.com Croporation Limited. All rights reserved.
 */
package cn.com.duiba.developer.center.biz.dao.developer.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.biz.dao.developer.AmbDeveloperWithdrawCashAuditDao;
import cn.com.duiba.developer.center.biz.entity.AmbDeveloperWithdrawCashAuditEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import org.springframework.stereotype.Repository;

/**
 * @create 2015年12月24日 下午8:11:13
 * @author Hermit
 * @version
 */
@Repository
public class AmbDeveloperWithdrawCashAuditDaoImpl extends BaseDao implements AmbDeveloperWithdrawCashAuditDao {

    @Override
    public void insert(AmbDeveloperWithdrawCashAuditEntity ambDeveloperWithdrawCashAuditEntity) {
        insert("insert", ambDeveloperWithdrawCashAuditEntity);
    }

    @Override
    public AmbDeveloperWithdrawCashAuditEntity findById(Long id) {
        return selectOne("findById", id);
    }

    @Override
    public AmbDeveloperWithdrawCashAuditEntity findValidPassAudit(Long developerId, String cashType) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("developerId", developerId);
        params.put("cashType", cashType);
        return selectOne(("findValidPassAudit"), params);
    }

    @Override
    public AmbDeveloperWithdrawCashAuditEntity findAuditing(Long developerId, String cashType) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("developerId", developerId);
        params.put("cashType", cashType);
        return selectOne("findAuditing", params);
    }

    @Override
    public void disableValidPassAudit(Long developerId, String cashType) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("developerId", developerId);
        params.put("cashType", cashType);
        update("disableValidPassAudit", params);
    }

    @Override
    public int updateStatusCreateToWait(Long auditId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auditId", auditId);
        return update("updateStatusCreateToWait", paramMap);
    }

    @Override
    public List<AmbDeveloperWithdrawCashAuditEntity> findByIds(List<Long> auditIds) {
        return selectList("findByIds", auditIds);
    }
}
