/**
 * duiba-developer AmbDeveloperWithdrawCashOrderDAOImpl.java
 * 
 * File Created at 2015年12月24日 下午8:12:12
 * $Id$
 *
 * Copyright 2015 duiba.com Croporation Limited.
 * All rights reserved.
 */
package cn.com.duiba.developer.center.biz.dao.developer.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.biz.dao.developer.AmbDeveloperWithdrawCashOrderDao;
import cn.com.duiba.developer.center.biz.entity.AmbDeveloperWithdrawCashOrderEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import org.springframework.stereotype.Repository;

/**
 *
 * @create 2015年12月24日 下午8:12:12
 * @author Hermit
 * @version
 */
@Repository
public class AmbDeveloperWithdrawCashOrderDaoImpl extends BaseDao implements AmbDeveloperWithdrawCashOrderDao {

    @Override
    public void insert(AmbDeveloperWithdrawCashOrderEntity ambDeveloperWithdrawCashOrderEntity) {
        insert("insert", ambDeveloperWithdrawCashOrderEntity);
    }

    @Override
    public List<AmbDeveloperWithdrawCashOrderEntity> findCashOrderList(Map<String, Object> queryPamas) {
        return selectList("findCashOrderList",queryPamas);
    }

    @Override
    public Long findCashOrderCount(Map<String, Object> queryPamas) {
        return selectOne("findCashOrderCount",queryPamas);
    }

    @Override
    public int updateStatusCreateToWaitPay(Long cashOrderId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cashOrderId", cashOrderId);
        return update("updateStatusCreateToWaitPay", paramMap);
    }

    @Override
    public int updateStatusCreateToFail(Long cashOrderId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cashOrderId", cashOrderId);
        return update("updateStatusCreateToFail", paramMap);
    }

    @Override
    public int updateStatusCreateToSuccess(Long cashOrderId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cashOrderId", cashOrderId);
        return update("updateStatusCreateToSuccess", paramMap);
    }


}
