package cn.com.duiba.developer.center.biz.dao.developer.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.developer.center.biz.dao.developer.PhoneBillListsDao;
import cn.com.duiba.developer.center.biz.entity.PhonebillListEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

@Repository
public class PhoneBillListsDaoImpl extends  BaseDao implements PhoneBillListsDao {

	@Override
	public List<PhonebillListEntity>selectByMobileAndFacePrice(String mobile,Integer facePrice) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("mobile", mobile);
		map.put("facePrice", facePrice);
		return selectList("selectByMobileAndFacePrice", map);
	}

	@Override
	public List<PhonebillListEntity>selectAllInFacePrice(List<Integer> facePrices) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("facePrices", facePrices);
		return selectList("selectAllInFacePrice", map);
	}

	@Override
	public PhonebillListEntity selectByFacePriceAndMobile(Integer price, String mobile) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("price", price);
		map.put("mobile", mobile);
		return selectOne("selectByFacePriceAndMobile", map);
	}

	@Override
	public List<PhonebillListEntity>selectAll() {
		return selectList("selectAll");
	}

	@Override
	public void delete(Long id) {
		delete("delete", id);
	}

	@Override
	public void insert(PhonebillListEntity PhonebillListEntity) {
		insert("insert", PhonebillListEntity);
	}

	@Override
	public void update(PhonebillListEntity phonebillListEntity) {
		update("update", phonebillListEntity);
	}

	@Override
	public PhonebillListEntity select(Long id) {
		return selectOne("select", id);
	}

}
