package cn.com.duiba.developer.center.biz.dao.floor.impl;

import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorCodeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorCodeDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * Created by suyuanlong on 16/8/10.
 */
@Repository
public class CreditsFloorCodeDaoImpl extends BaseDao implements CreditsFloorCodeDao{
    @Override
    public CreditsFloorCodeDto insertFloorCode(CreditsFloorCodeDto dto) {
         int  ret= insert("insertFloorCode", dto);
         return dto;
    }
    @Override
    public int updateFloorCode(CreditsFloorCodeDto dto) {
        return update("updateFloorCode", dto);
    }

    @Override
    public List<CreditsFloorCodeDto> selectFloorCodesByType(PageQueryEntity params) {
        return selectList("selectFloorCodesByType",params);
    }

    @Override
    public Integer selectFloorCodesCountByType(PageQueryEntity params) {
        return selectOne("selectFloorCodesCountByType",params);
    }

    @Override
    public CreditsFloorCodeDto selectFloorCodeById(Long id) {
        return selectOne("selectFloorCodeById",id);
    }

    @Override
    public List<CreditsFloorCodeDto> selectFloorCodeList(List<Long> ids) {
        if(ids==null||ids.isEmpty()) return Collections.emptyList();
        Map<String,Object> params = Maps.newHashMap();
        params.put("ids",ids);
        return selectList("selectFloorCodeList",params);
    }
}
