package cn.com.duiba.developer.center.biz.dao.floor.impl;

import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.biz.entity.ShowcaseEntity;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorShowcaseDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;

@Repository
public class CreditsFloorShowcaseDaoImpl  extends BaseDao  implements CreditsFloorShowcaseDao{

	@Override
	public FloorShowcaseContentDto selectShowcaseContent(long appId, int place) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("appId", appId);
		map.put("place", place);
		return selectOne("selectShowcaseContent",map);
	}

	@Override
	public List<FloorShowcaseContentDto> selectShowcaseList(long appId) {
		return selectList("selectShowcaseList", appId);
	}

	@Override
	public void saveShowcaseConfig(ShowcaseEntity showcaseEntity) {
		insert("saveShowcase",showcaseEntity);
	}

	@Override
	public void delShowcaseConfig(Long appId, Integer place) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("appId", appId);
		map.put("place", place);
		map.put("status","close");
		update("delShowcaseConfig",map);
	}

	@Override
	public void updateShowcaseConfig(ShowcaseEntity showcaseEntity) {
		update("updateShowcaseConfig",showcaseEntity);
	}

	@Override
	public FloorShowcaseContentDto getShowcaseContentIgnoreStatus(long appId, int place) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("appId", appId);
		map.put("place", place);
		return selectOne("getShowcaseContentIgnoreStatus",map);
	}
}
