package cn.com.duiba.developer.center.biz.dao.internalletter.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dao.internalletter.InternalLetterDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import cn.com.duiba.developer.center.common.dao.DatabaseSchema;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/15.
 */
@Repository
public class InternalLetterDaoImpl extends BaseDao implements InternalLetterDao {
    @PostConstruct
    private void init(){
        this.databaseSchema = DatabaseSchema.MANAGER;
    }

    @Override
    public InternalLetterDO find(Long id) {
        return selectOne("find",id);
    }

    @Override
    public InternalLetterDO findForUpdate(Long id) {
        return selectOne("findForUpdate",id);
    }

    @Override
    public int insert(InternalLetterDO letter) {
        return insert("insert",letter);
    }

    @Override
    public int update(InternalLetterDO letter) {
        return update("update",letter);
    }

    @Override
    public int updateDeleted(Long id) {
        return update("updateDeleted",id);
    }

    @Override
    public int delete(InternalLetterDO letter) {
        return delete("delete",letter.getId());
    }

    @Override
    public List<InternalLetterDO> findListPage(PageQueryEntity param) {
        return selectList("findListPage",param);
    }

    @Override
    public long findCountPage(PageQueryEntity param) {
        return selectOne("findCountPage",param);
    }

    @Override
    public int updateSendStatue(Long id) {
        return update("updateSendStatue",id);
    }

    @Override
    public List<Long> findAllCanPushIds() {
        return selectList("findAllCanPushIds");
    }

}
