package cn.com.duiba.developer.center.biz.dao.schedule;
import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.enums.AppPushStatusEnum;
import cn.com.duiba.developer.center.biz.entity.AppPushTaskEntity;

/**
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/8 10:36
 */
public interface AppPushTaskDao {
    /**
     * 查询可编辑的app推送任务</br>
     * 查询条件： status = 'INIT'
     *
     * @author yaocheng
     * @return
     * @since JDK 1.6
     */
    List<AppPushTaskEntity> queryAppPushTaskByDuibaId(Long duibaTaskId);

    /**
     * 新建开发者计划任务
     * @param appPushTaskEntity
     */
    void insert(AppPushTaskEntity appPushTaskEntity);

    /**
     * 更新计划任务
     * @param appPushTaskEntity
     */
    void update(AppPushTaskEntity appPushTaskEntity);

    /**
     * 通过duibaTaskId删除开发者计划任务相关数据
     * @param duibaTaskId
     */
    void deleteByDuibaTaskId(Long duibaTaskId);

    /**
     * 更新计划任务时间
     * @param duibaTaskId
     */
    void updatePushTimeByDuibaTaskId(Long duibaTaskId, Date date);

    void delete(Long duibaTaskId,int deleted);
    /**
     * 计划任务列表下app查询
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<AppPushTaskEntity> selectScheduledTaskAppList(int pageIndex, int pageSize);
    /**
     * 计划任务列表下app count
     * @return
     */
    Integer selectScheduledTaskAppCount();

    /**
     * 查询待执行的app推送任务<br/>
     *
     * @author zhanglihui
     * @return
     */
    List<AppPushTaskEntity> selectAppPushTaskToExec(int queryTaskLimit);

    /**
     * 更新计划任务状态<br/>
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param status        要更新的状态 {@link AppPushStatusEnum}
     */
    void updateAppPushTaskStatus(long appPushTaskId, String status);

    /**
     * 更新计划任务执行时间
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param pushTime      执行时间
     * @return
     */
    void updateAppPushTaskTime(long appPushTaskId, Date pushTime);
    
    AppPushTaskEntity selectById(long id);

    /**
     * 更新计划任务扩展信息<br/>
     *
     * @author zhanglihui
     * @param appPushTaskId  任务主键
     * @param extParam     更新的扩展信息
     * @return
     */
    void updateExtParamById(long appPushTaskId, String extParam);

    /**
     * 更新状态  不更新 SUCC-成功; FAILED-失败
     * @param duibaTaskId
     * @param status 
     */
	void updateFilterStatus(Long duibaTaskId, String status);
	/**
     * 批量查询计划任务下app数量
     * @param pushTaskIds
     * @return
     */
	Map<Long,Map<String,String>> selectBatchScheduledTaskAppNums(List<Long> pushTaskIds);

}
